/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/** 
 *  @file planar2.h
 *  @brief Classes for 'From planar curves'
 */
#if !defined(__PLANAR2_H__)
#define __PLANAR2_H__

#include "mg/Curve.h"
class MGCurve;
class MGFace;
class MGGroup;
class MGPlane;

namespace mgcalc{
	///@name MGPlanarCurveGroup::notify(int) ̈
	//@{
	extern const int OTHER;
	extern const int ADD_CHILD;
	extern const int REMOVE_CHILD;
	extern const int ADD_SIBLING;
	extern const int MODIFY_LOOP_BEFORE;
	extern const int MODIFY_LOOP_AFTER;
	extern const int MODIFY_PARENT_BEFORE;
	extern const int MODIFY_PARENT_AFTER;
	extern const int CLEAR_ALL;
	//@}

	/**
	 *  @brief  ʋȐ̃c[\
	 *
	 *  T^I Composite p^[ō\NXłB
	 *  ؍\̐eq֌ẂAʋȐ̃oEfBO{bNX
	 *  ܊֌WɂĒ`ĂB{bNX傫ق
	 *  ełB
	 *
	 *  ܂ÃO[vɑ邷ׂĂ̕ʋȐ̕ʂ
	 *  𖳎Έv邪Aface ʂۂɌ
	 *  vZ邽߁Aꂼ̐߁AtƂɕʃIuWFNg
	 *  ĂB
	 *
	 *  [gɂ͋ȐȂAʃIuWFNǵu\v
	 *  B
	 */
	class MGPlanarCurveGroup{
	public:
		using MYELM=std::unique_ptr<MGPlanarCurveGroup>;
		using MYLST=std::list<MYELM>;
		using group=MYLST;

		typedef group::iterator             iterator;
		typedef group::const_iterator       const_iterator;
		typedef group::reference            reference;
		typedef group::const_reference      const_reference;

		/**
		 *  @brief  [g쐬B
		 */
		MGPlanarCurveGroup();

		reference       back(){ return m_children.back();}
		const_reference back() const{ return m_children.back();}

		iterator       begin(){ return m_children.begin();}
		const_iterator begin() const{ return m_children.begin();}

		/**
		 *  @brief   Ȑ̃oEfBOԂ
		 */
		const MGBox& box() const{ return loop()->box();}

		/**
		 *  @brief IuWFNgNA
		 */
		void clear();

		/**
		 *  @brief  ړÎ̂𐶐B
		 */
		MGGroup* create_face() const;

		iterator       end(){ return m_children.end();}
		const_iterator end() const{ return m_children.end();}

		//@{
		/**
		 *  @brief  qO[v
		 *  @param i  m[hwq
		 */
		iterator       find_child(const_iterator i);
		const_iterator find_child(const_iterator i) const;
		//@}

		reference       front(){ return m_children.front();}
		const_reference front() const{ return m_children.front();}

		/**
		 *  @brief  qO[vǉ]
		 *  @param  loop  ʋȐȐȋȐ
		 *  @param  plane  @a loop ̏镽
		 */
		MGPlanarCurveGroup* insert(
			const MGCurve*  loop,
			MGPlane*        plane
			);

		/**
		 *  @brief  IuWFNgLǂ
		 */
		bool is_null() const;

		/**
		 *  @brief   [gO[vǂ
		 */
		bool is_root() const;

		/**
		 *  @brief  qO[vL邩ǂ
		 *
		 *  @note qO[v̋Ȑ͂ǂeO[v̋Ȑ̓ɂ
		 */
		bool has_children() const{ return !m_children.empty();}

		/**
		 *  @brief ʋȐ擾
		 */
		const MGCurve* loop() const{ return m_loop;}

		/**
		 *  @brief  fobOp
		 *  @param  os  o͗pXg[
		 */
		void out(std::ostream& os) const;

		//@{
		/**
		 *  @brief  eO[v擾
		 */
		MGPlanarCurveGroup* parent(){ return m_parent;}
		const MGPlanarCurveGroup* parent() const{ return m_parent;}
		//@}

		//@{
		/**
		 *  @brief  ʕʂ擾
		 */
		MGPlane* plane(){ return m_plane.get();}
		const MGPlane* plane() const{ return m_plane.get();}
		//@}

		/**
		 *  @brief  qO[v폜
		 *  @param  i  m[hwq
		 */
		void remove_child(iterator i);

		/**
		 *  @brief  eO[vZbg
		 *  @param  parent  eƂȂm[h
		 */
		void set_parent(MGPlanarCurveGroup* parent);

		/**
		 *  @brief  ʂZbg
		 *  @param  plane  
		 */
		void set_plane(MGPlane* plane){ m_plane = std::unique_ptr<MGPlane>(plane);}

	private:
		
		std::unique_ptr<MGPlane>      m_plane;// ʋȐ̋ʕ

		// ʋȐ̂
		// null̏ꍇÃO[v'root'ł
		const MGCurve*              m_loop;

		// ̐eO[vw
		// null ̏ꍇÃO[v'root'ł
		MGPlanarCurveGroup*         m_parent;

		// qO[v
		MYLST m_children;

		/**
		 *  @brief  qO[v𐶐
		 *  @param  loop  ʋȐȐ
		 *  @param  plane @a loop ̏镽
		 *  @param  parent  em[h
		 */
		MGPlanarCurveGroup(
			const MGCurve*      loop,
			MGPlane*            plane,
			MGPlanarCurveGroup* parent
		);

		/**
		 *  @brief  qO[vǉ
		 *  @param  loop  ʋȐȐ
		 *  @param  plane @a loop ̏镽
		 */
		MGPlanarCurveGroup* add_child(
			const MGCurve*  loop,
			MGPlane*        plane
		);

		/**
		 *  @brief  eO[v}
		 *  @param  loop  ʋȐȐ
		 *  @param  plane @a loop ̏镽
		 */
		MGPlanarCurveGroup* add_parent(
			const MGCurve*  loop,
			MGPlane*        plane
		);

		/**
		 *  @brief  ZO[vǉ
		 *  @param  loop  ʋȐȐ
		 *  @param  plane @a loop ̏镽
		 */
		MGPlanarCurveGroup* add_sibling(
			const MGCurve*  loop,
			MGPlane*        plane
		);

		/**
		 *  @brief  c[\ɕύXƂɌĂяo
		 *  @param  what  ǂύX̂rbgtB[hlB
		 */
		void notify(int what) const;
		
		/**
		 *  @brief  ʋȐZbg
		 *  @param  curve  ʋȐȐ
		 *  @param  plane @a loop ̏镽
		 */
		void set_loop(const MGCurve* curve, MGPlane* plane);

		// ȉ͎̂̂Ȃ
		MGPlanarCurveGroup(const MGPlanarCurveGroup&)=delete;
		MGPlanarCurveGroup& operator=(const MGPlanarCurveGroup&)=delete;

		/// fobOp
		friend std::ostream& operator<<(std::ostream& os, const MGPlanarCurveGroup& gp);
	};

	/**
	 *  @brief ʋȐc[ƕʂ̃yANX
	 *
	 *  std::pair<T, U> gƖOȂ邽ߎOŃyANX...
	 */
	class MGPCGPlanePair{
	public:
		MGPCGPlanePair(){}
		/**
		 *  @brief  ʋȐc[Ƒ\IȕʂIuWFNg𐶐
		 *  @param  root  ʋȐc[̃[g
		 *  @param  plane  ʋȐQ̋ʕʂ̑\IIuWFNg
		 */
		MGPCGPlanePair(MGPlanarCurveGroup* root, MGPlane* plane);

		void clear();
		bool is_null() const;

		MGPlane*       plane(){ return m_plane.get();}
		const MGPlane* plane() const{ return m_plane.get();}

		MGPlanarCurveGroup*       root(){ return m_root.get();}
		const MGPlanarCurveGroup* root() const{ return m_root.get();}

	private:
		std::unique_ptr<MGPlanarCurveGroup> m_root;
		std::unique_ptr<MGPlane>            m_plane;

		// ͎Ȃ
		MGPCGPlanePair(const MGPCGPlanePair&)=delete;
		MGPCGPlanePair& operator=(const MGPCGPlanePair&) = delete;

		friend class MGPlanarSurfManager;
	};

	/**
	 *  @brief  ʋȐc[QgDNX
	 *
	 *  ̕ʋȐ([v)W߁Aʂ镽ʂɂĕނA
	 *  [vɂ faceQ 쐬NXłB
	 */
	class MGPlanarSurfManager{
	public:
		typedef MGPCGPlanePair     PCGPair;
		using UniquePCGPair = std::unique_ptr<PCGPair>;
		typedef std::vector<UniquePCGPair> PCGroup;
		
		typedef PCGroup::iterator             iterator;
		typedef PCGroup::const_iterator       const_iterator;
		typedef PCGroup::size_type            size_type;

		MGPlanarSurfManager(){}

		/**
		 *  @brief  ȐO[vɒǉ
		 *  @param  curve  ȐIuWFNg
		 */
		bool add(const MGCurve* curve);

		bool empty() const{ return m_pcg.empty(); }
		size_type size() const{ return m_pcg.size(); }

		/**
		 *  @brief  face 𐶐
		 */
		MGGroup* create_face();

	private:
		iterator       begin(){ return m_pcg.begin();}
		const_iterator begin() const{ return m_pcg.begin();}

		iterator       end(){ return m_pcg.end();}
		const_iterator end() const{ return m_pcg.end();}

		iterator       find(const MGPlane& plane);
		const_iterator find(const MGPlane& plane) const;

		// ͎Ȃ
		MGPlanarSurfManager(const MGPlanarSurfManager& other)=delete;
		MGPlanarSurfManager& operator=(const MGPlanarSurfManager& other) = delete;

		PCGroup m_pcg;
	};

} // namespace mgcalc

#endif // __PLANAR2_H__
