/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// planar.cpp
// implementation for planar checker
#include "stdafx.h"
#include "Calc/planar.h"
#include "mg/Ellipse.h"
#include "mg/LBRep.h"
#include "mg/RLBRep.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

namespace mgcalc{
	// Returns whether curve is strictly planar or not.
	bool MGCurvePlanarInfo::calculate(unsigned int mask){
		m_mask = mask;

		m_mask &= ~(CPI_PLANAR | CPI_3D | CPI_POINT | CPI_STRAIGHT | CPI_PLANE);
		const MGCurve& curve = m_curve;

		if(const MGStraight* sl = dynamic_cast<const MGStraight*>(&curve)){
			m_mask |= CPI_STRAIGHT;
			m_mask &= ~(CPI_3D | CPI_PLANAR | CPI_POINT | CPI_PLANE);
			if(!(m_mask & CPI_CHECK_ONLY)){
				m_sl = *sl;
			}
			return true;
		}

		if(const MGEllipse* el = dynamic_cast<const MGEllipse*>(&curve)){
			m_mask |= CPI_PLANAR;
			m_mask &= ~(CPI_3D | CPI_POINT | CPI_STRAIGHT);
			if(!(m_mask & CPI_CHECK_ONLY)){
				m_pl = MGPlane(el->normal(), el->center());
				m_mask |= CPI_PLANE;
			}
			return true;
		}

		int ret = 0;
		MGPlane plane; MGStraight line; MGPosition pos;
		if(const MGLBRep* brep = dynamic_cast<const MGLBRep*>(&curve)){
			ret = brep->planar(plane, line, pos);
		}else if(const MGRLBRep* rbrep = dynamic_cast<const MGRLBRep*>(&curve)){
			ret = rbrep->planar(plane, line, pos);
		}else{
			// exit
			return false;
		}

		switch(ret){
		case 0: // 3D
			m_mask |= CPI_3D;
			m_mask &= ~(CPI_PLANAR | CPI_POINT | CPI_STRAIGHT | CPI_PLANE);
			break;
		case 1: // 0D
			m_mask |= CPI_POINT;
			m_mask &= ~(CPI_PLANAR | CPI_3D | CPI_STRAIGHT | CPI_PLANE);
			if(!(m_mask & CPI_CHECK_ONLY)){
				m_pos = pos;
			}
			break;
		case 2: // 1D
			m_mask |= CPI_STRAIGHT;
			m_mask &= ~(CPI_PLANAR | CPI_3D | CPI_POINT | CPI_PLANE);
			if(!(m_mask & CPI_CHECK_ONLY)){
				m_sl = line;
			}
			break;
		case 3: // 2D
			m_mask |= CPI_PLANAR | CPI_PLANE;
			m_mask &= ~(CPI_STRAIGHT | CPI_3D | CPI_POINT);
			if(!(m_mask & CPI_CHECK_ONLY)){
				m_pl = plane;
			}
			break;
		default:
			// ????
			m_mask = 0;
			return false;
		}
		return true;
	}
} // mgcalc
