/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
#if !defined( __MGPROJECT_H__)
#define __MGPROJECT_H__

class MGFSurface;
class MGPoint;

namespace mgcalc{
	/**
	 *  @brief eZ̏ʃIuWFNgɃANZXNX
	 *
	 *  ӓ_͓eɂĐꂽIuWFNg̎擾@ɂ
	 *  łBI new ꂽIuWFNgǗĂ邽߁A
	 *  p҂𑼂ɉ񂷂ɂ́Aresult() gp release() Ă
	 *  KvB
	 */
	class MGProject{
	public:
		using MYELM=std::unique_ptr<MGGel>;
		using MYLST=std::list<MYELM>;

		/**
		 *  @brief  ef[^Zbg
		 *  @param  objective  ẽIuWFNg
		 *  @param  subjective  eIuWFNg
		 *  @param  direction  e
		 *
		 *  eZɗpef[^Zbg邾łB
		 *  ۂ̌vZ @c calculate() ĂԂƂŊJnB
		 *
		 *  @note direction w肵ȂꍇAʒesƂӖB
		 *  ́AMGCL ̊Kɂ̂łB
		 */
		MGProject(
			const MGObject* objective,
			const MGObject* subjective,
			const MGVector& direction = mgNULL_VEC
			);

		/**
		 *  @brief  evZs
		 *
		 *   true ߂ĂB
		 *  eɂ鐶 @c result() ŎQƂ邱ƂłB
		 */
		bool calculate();

		/// ΁AeԂ
		/// ȂΗxNgԂ
		const MGVector& direction() const{ return m_direction;}

		/// ẽIuWFNgԂ
		const MGObject* objective() const{ return m_objective;}

		/// eIuWFNgԂ
		const MGObject* subjective() const{ return m_subjective;}
		
		///@name eʃIuWFNg
		//@{
		MYLST& result(){ return m_result;}
		const MYLST& result() const{ return m_result;}
		//@}

	private:

		// 3̃o̊Ԃɂ͎̊֌W
		// m_result == m_objective->project(m_subjective, m_direction);
		const MGObject* m_objective;
		const MGObject* m_subjective;
		MGVector        m_direction;

		MYLST m_result; // e

		/// Ǘv郁of[^
		/// ̃o֐͎gp֎~
		MGProject(const MGProject&)=delete;
		MGProject& operator=(const MGProject&)=delete;

		//@{
		/// ^Cv̓evZ֐
		bool calc_hc(const MGShell* shell, const MGCurve* curve);
		bool calc_sc(const MGFSurface* surf, const MGCurve* curve);
		bool calc_hp(const MGShell* shell, const MGPoint* point);
		bool calc_sp(const MGFSurface* surf, const MGPoint* point);
		//@}

	};
} // mgcalc

#endif //__MGPROJECT_H__
