/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

// mgjoin.h
// declaraion for functions about join operation
#if !defined( __MGJOIN_H__)
#define __MGJOIN_H__

#include "topo/Shell.h"
#include "topo/Face.h"
class MGCurve;
class MGCompositeCurve;

namespace mgcalc{
	/// Makes a composite curve connect obj2 at its endpoint.
	/// Returns true if succeeds.
	bool join(MGCompositeCurve* obj, const MGCurve* obj2);

	// Makes a shell connect f at its common edge.
	// Returns true if succeeds.
	inline bool join(MGShell* she, const MGFace* f){
		return she->merge_at_common_edge(*f);
	}
	inline bool join(MGShell* she, const MGSurface* srf){
		return she->merge_at_common_edge(*srf);
	}
	// Join obj2 to obj, which obj2 is required to be face or surface.
	bool join(MGShell* obj, const MGObject* obj2);

	// Join obj2 to obj. (dispatcher function)
	bool join(MGObject* obj, const MGObject* obj2);

	/// Creates a kernel object of a composite object.
	MGObject* join_seed(const MGObject& obj);
}

#endif //__MGJOIN_H__
