/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/** @file fillet.h
 *  @brief declaration for fillet module 
 */
#if !defined( __FILLET_H__)
#define __FILLET_H__
#include <memory>  // for std::unique_ptr

class MGCurve;

namespace mgcalc{
	/**
	 *  @brief  tBbg𐶐B
	 *  @param  curve1  tBbgȐ̂ЂƂ
	 *  @param  hint_param1  @a curve1 ̃sbNʒuɂp[^
	 *  @param  curve2  tBbgȐ̂ӂ
	 *  @param  hint_param2  @a curve2 ̃sbNʒuɂp[^
	 *  @param  radius  tBbgȐ̔a
	 *
	 *  MGEllise ̃RXgN^ŃtBbg̉~ʂ𐶐֐B
	 *   @a curve1, @a curve2 sbNʒuɋ߂[_
	 *  tBbgJ[uł悤Ȃ΁AJ[ũtBbgԂB
	 */
	std::unique_ptr<MGCurve> fillet_arc(
		const MGCurve& curve1,
		double&        hint_param1,
		const MGCurve& curve2,
		double&        hint_param2,
		double         radius
		);

	/**
	 *  @brief fillet ֐̖߂l^̂߂̍\
	 */
	struct MGCurveFilletInfo{
		std::unique_ptr<MGCurve>  m_fillet;
		std::unique_ptr<MGCurve>  m_curve1;
		std::unique_ptr<MGCurve>  m_curve2;
	};

	/**
	 *  @brief  tBbg̐ƃgȐ̐B
	 *  @param  curve1  tBbgȐ̂ЂƂ
	 *  @param  hint_param1  @a curve1 ̃sbNʒuɂp[^
	 *  @param  curve2  tBbgȐ̂ӂ
	 *  @param  hint_param2  @a curve2 ̃sbNʒuɂp[^
	 *  @param  radius  tBbgȐ̔a
	 *
	 *  eIɂ fillet_arc ֐ƓsB
	 *  Ɉ̋Ȑ̃gsB
	 */ 
	std::unique_ptr<MGCurveFilletInfo> fillet(
		const MGCurve& curve1,
		double&        hint_param1,
		const MGCurve& curve2,
		double&        hint_param2,
		double         radius
		);
} // namespace mgcalc

#endif //__FILLET_H__
