/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// fillet.cpp
// implementation for fillet module
#include "stdafx.h"
#include "Calc/curve.h"
#include "Calc/fillet.h"
#include "mg/Ellipse.h"
#include "mg/Plane.h"
#include "mg/Straight.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

namespace{

	std::unique_ptr<MGCurve> generate_arc(
		const MGCurve& curve1, double& t1,
		const MGCurve& curve2, double& t2,
		const MGUnit_vector& normal,
		double radius,
		int& ret
		){
		std::unique_ptr<MGCurve> arc(
			new MGEllipse(curve1,curve2,normal,radius,t1,t2,ret));
		if(ret)
			return std::unique_ptr<MGCurve>(nullptr);

		MGPosition Ps=arc->start_point();
		MGPosition Pe=arc->end_point();
		MGPosition P1=curve1.eval(t1);
		if((Pe-P1).len()<(Ps-P1).len())
			arc->negate();
		return arc;
	}

	// extension ƁA
	// ret -1 : s
	// ret 0 : ǂ curvei Ȃčς
	// ret 1 : curve1 ͉ȂƃtBbgłȂ
	// ret 2 : curve2 ͉ȂƃtBbgłȂ
	// ret 3 : ׂĂ curvei ȂƃtBbgłȂ
	//
	// ܂Aextension ̒lɂ hint_param ̖߂lƂĂ̈ӖႤ:
	// ret -1 : Ӗ
	// ret 0 : curvei ́@tBbgn_ɂp[^
	// ret 1 : hint1  ̒[_ƈvق̒[_̃p[^A
	//         hint2  curve2 ̃p[^
	// ret 2 : {ret 1  1  2 u}
	// ret 3 : hinti  ̃p[^ (p)
	std::unique_ptr<MGCurve> fillet_aux(
		const MGCurve& curve1,
		double&        hint_param1,
		const MGCurve& curve2,
		double&        hint_param2,
		double         radius,
		int&           extension
	){
		assert(curve1.in_range(hint_param1));
		assert(curve2.in_range(hint_param2));
		assert(radius > 0.);  // 0 ͋Ȃ (0 ̂Ƃ͑SRႤ)

		// 1. ʋȐǂmF
		MGPlane plane;
		if(!curve1.is_coplanar(curve2,plane)){
			// AEc
			extension = -1;
			return std::unique_ptr<MGCurve>(nullptr);
		}
		const MGUnit_vector& normal = plane.normal();

		// 2. ̋ȐɎȂŃtBbg܂邩
		int ret = 0;
		
		std::unique_ptr<MGCurve> fil=
			generate_arc(curve1,hint_param1,curve2,hint_param2,normal,radius,ret);
		if(!ret){
			extension = 0;
			return fil;
		}
		double zero1 = 0;

		// 2.1 ̋ȐăgCĂ݂
		// ŉ
		std::unique_ptr<MGStraight> ext1(mgcalc::extension(curve1, hint_param1));

		// 2.2 ext1 vs curve2
		fil =generate_arc(*ext1,zero1,curve2,hint_param2,normal,radius,ret);
						// ̕Ăق̃p[^͕K[
		if(!ret){
			extension = 1;
			return fil;
		}
		assert(zero1 == 0.);

		double zero2 = 0.;
		
		// 2.3 curve1 vs ext2
		std::unique_ptr<MGStraight> ext2(mgcalc::extension(curve2, hint_param2));
		fil =generate_arc(curve1,hint_param1,*ext2,zero2,normal,radius,ret);
		// ̕Ăق̃p[^͕K[
		if(!ret){
			extension = 2;
			return fil;
		}
		assert(zero2 == 0.);

		// 2.4 ext1 vs ext2
		fil =generate_arc(*ext1,zero1,*ext2,zero2,normal,radius,ret);
		if(!ret){
			extension = 3;
			return fil;
		}
		extension = -1;
		return std::unique_ptr<MGCurve>(nullptr);
	}
} // namespace

namespace mgcalc{
	// tBbg̐ƃgȐ̐
	std::unique_ptr<MGCurveFilletInfo> fillet(
		const MGCurve& curve1,
		double&        hint_param1,
		const MGCurve& curve2,
		double&        hint_param2,
		double         radius
		){
		int extension = 0;
		std::unique_ptr<MGCurveFilletInfo> info(new MGCurveFilletInfo);
		info->m_fillet=fillet_aux(curve1,hint_param1,curve2,hint_param2,radius,extension);
		if(extension == -1){
			// failed.
			return std::unique_ptr<MGCurveFilletInfo>(nullptr);
		}

		assert(info->m_fillet.get());
		const MGCurve& fil = *info->m_fillet;

		switch(extension){
		case 0:
			// curve1, curve2 ʏ̈ӖŃg
			{
				assert(curve1.in_range(hint_param1));
				assert(curve2.in_range(hint_param2));
				info->m_curve1.reset(curve1.clone());
				if(curve1.eval(hint_param1, 1) % fil.eval(fil.param_s(), 1) < 0){
					info->m_curve1->trim_start(hint_param1);
				}else{
					info->m_curve1->trim_end(hint_param1);
				}
				
				info->m_curve2.reset(curve2.clone());
				if(curve2.eval(hint_param2, 1) % fil.eval(fil.param_e(), 1) < 0){
					info->m_curve2->trim_end(hint_param2);
				}else{
					info->m_curve2->trim_start(hint_param2);
				}
			}
			break;
		case 1:
			// curve1 ̓g, curve2 ͉
			{
				assert(curve1.in_range(hint_param1));
				info->m_curve1.reset(curve1.clone());
				if(curve1.eval(hint_param1, 1) % fil.eval(fil.param_s(), 1) < 0){
					info->m_curve1->trim_start(hint_param1);
				}else{
					info->m_curve1->trim_end(hint_param1);
				}

				const MGPosition& end   = fil.end_point();
				std::unique_ptr<MGStraight> ext2(
					new MGStraight(curve2.eval(hint_param2), end)
					);
				info->m_curve2 = connect(curve2, *ext2);
			}
			break;
		case 2:
			// curve1 ͉Acurve2 ̓g
			{
				const MGPosition& start   = fil.start_point();
				std::unique_ptr<MGStraight> ext1(
					new MGStraight(curve1.eval(hint_param1), start)
					);
				info->m_curve1 = connect(curve1, *ext1);

				assert(curve2.in_range(hint_param2));
				info->m_curve2.reset(curve2.clone());
				if(curve2.eval(hint_param2, 1) % fil.eval(fil.param_e(), 1) < 0){
					info->m_curve2->trim_end(hint_param2);
				}else{
					info->m_curve2->trim_start(hint_param2);
				}
			}
			break;
		case 3:
			// curve1, curve2 
			{
				const MGPosition& start   = fil.start_point();
				std::unique_ptr<MGStraight> ext1(
					new MGStraight(curve1.eval(curve1.param_se(hint_param1)), start)
					);
				info->m_curve1 = connect(curve1, *ext1);

				const MGPosition& end   = fil.end_point();
				std::unique_ptr<MGStraight> ext2(
					new MGStraight(curve2.eval(curve2.param_se(hint_param2)), end)
					);
				info->m_curve2 = connect(curve2, *ext2);
			}
			break;
		}
		if(!(info->m_curve1.get())||!(info->m_curve2.get()))
			return std::unique_ptr<MGCurveFilletInfo>(nullptr);

		return info;
	}
	
	// tBbg𐶐
	std::unique_ptr<MGCurve> fillet_arc(
		const MGCurve& curve1,
		double&        hint_param1,
		const MGCurve& curve2,
		double&        hint_param2,
		double         radius
		){
		int extension = 0;
		return fillet_aux(curve1, hint_param1, curve2, hint_param2, radius, extension);
	}
} // mgcalc
