/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 *  @file ellipse.h
 */
#if !defined(__MGCALC_ELLIPSE_H__)
#define __MGCALC_ELLIPSE_H__

class MGEllipse;
class MGPosition;
class MGPlane;

namespace mgcalc{
	/**
	 *  @brief  œ_ƒʉߓ_^đȉ~𐶐
	 *  @param  F0  œ_
	 *  @param  F1  œ_
	 *  @param  P   ȉ~̓_
	 *
	 *  @a F0  @a F1 ͑قȂœ_łȂΎsB
	 *  @a P 2œ_ԒɂƂsB
	 */
	std::unique_ptr<MGEllipse> create_ellipse(
		const MGPosition& F0,
		const MGPosition& F1,
		const MGPosition& P
		);

	/**
	 *  @brief  `ɓڂȉ~𐶐
	 *  @param  plane  ȉ~镽ʂɕsȕ
	 *  @param  corner1  ȉ~ڂ`̃R[i[̍W
	 *  @param  corner2  corner1 ̑Βp̍W̃qg
	 *
	 *   @a corner2  @a corner1 ʂ @a plane ɕsȕʂ
	 *  ĂȂꍇA@a corner2 ͕sȕʂɖʒeA
	 *  ꂪvZɗpB
	 */
	std::unique_ptr<MGEllipse> create_ellipse(
		const MGPlane&    plane,
		const MGPosition& corner1,
		const MGPosition& corner2
		);
	
} // namespace mgcal

#endif // __MGCALC_ELLIPSE_H__
