/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

// decomposite.h
// declaraion for functions about decomposition
#if !defined( __DECOMPOSITE_H__)
#define __DECOMPOSITE_H__

class MGGroup;
class MGShell;
class MGCompositeCurve;
class MGObject;

namespace mgcalc{
	// details of implementaion
	namespace detail{
		// decomposite a shell into its components
		void decomposite(const MGShell& she, MGGroup& g);

		// decomposite a composite curve into its components
		void decomposite(const MGCompositeCurve& c, MGGroup& g);
	}

	// Releases elements of a composite object, or decomposite a polyline
	// into straight segments.
	bool decomposite(
		const MGObject& obj, // composite object. e.g., MGCompositeCurve, MGShell.
		MGGroup& output      // to which the resulting components are inserted
		);
}

#endif //__DECOMPOSITE_H__
