/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

// chamfer.h
// declaration for fillet module
#if !defined( __CHAMFER_H__)
#define __CHAMFER_H__
#include <memory>  // for std::unique_ptr
#include "mg/Straight.h"

class MGCurve;

namespace mgcalc{
	/**
	 *  class ChamferParam
	 *
	 *  ʎvZɎgpf[^ŁA_Iɂ܂Ƃ܂̂̂
	 *  NX
	 */
	class ChamferParam{
	public:
		/// ftHgRXgN^
		ChamferParam() : m_curve(0){}

		/// ̃IuWFNgLł邩ǂ𒲂ׂ
		bool is_null() const{ return m_curve == 0;}

		/// ȐԂ
		const MGCurve* curve() const{ return m_curve;}

		/// ʎ苗Ԃ
		double distance() const{ return m_distance;}

		/// Ȑ̃sbNʒup[^̌`ŕԂ
		double hint() const{ return m_hint;}

		/**
		 *  @brief  ʎf[^Zbg
		 *  @param  curve     ʎ肷Ȑ̈
		 *  @param  distance  ʎ苗
		 *  @param  hint      @a curve ̃sbNʒuɂp[^
		 *
		 *  @a distance s̒lłƁÅ֐͎sB
		 *  @a hint  @a curve ̒`O̒lłƂÅ֐͎sB
		 */
		bool set(const MGCurve* curve, double distance, double hint);

	private:
		const MGCurve*  m_curve;     ///< ʎ肷Ȑ
		double          m_distance;  ///< ʎ苗
		double          m_hint;      ///< Ȑ̃sbNʒu
	};

	/**
	 *  class ChamferResult
	 *
	 *  ʎvŽʂ̌^
	 */
	class ChamferResult{
	public:
		ChamferResult(const ChamferParam* param1, const ChamferParam* param2);
		~ChamferResult();

		/// ʎvZJn
		bool chamfer();

		/**
		 *  @brief  ʎ蕔̋Ȑ𐶐
		 *
		 *  ֐ @c chamfer() ̌ďołȂƁÅ֐͎sB
		 */
		MGCurve* chamfer_line() const;

		/**
		 *  @brief  ʎ̋Ȑ̌`𐶐
		 *  @param  i  ǂ瑤̋Ȑ
		 *
		 *  @i  1  2 Ŏw肷
		 *  RXgN^̑1ƂĎw肵Ȃ 1 A
		 *  2ƂĎgpȂ 2 w肷΂悢B
		 *  ȊO̒lw肷ƁÅ֐͎sB
		 *
		 *  ֐ @c chamfer() ̌ďołȂƁÅ֐͎sB
		 */
		std::unique_ptr<MGCurve> trimmed_curve(int i) const;

	private:
		class Private;
		std::unique_ptr<Private> m_impl;
	};
} // namespace mgcalc

#endif //__CHAMFER_H__
