package jp.sourceforge.sxdbutils.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CaseInsensitiveHashMap<V> extends HashMap<String, V> {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * @see java.util.Map#containsKey(java.lang.Object)
	 */
	public boolean containsKey(Object key) {
		return super.containsKey(key.toString().toLowerCase());
	}

	/**
	 * @see java.util.Map#get(java.lang.Object)
	 */
	public V get(Object key) {
		return super.get(key.toString().toLowerCase());
	}

	/**
	 * @see java.util.Map#put(java.lang.Object, java.lang.Object)
	 */
	public V put(String key, V value) {
		return super.put(key.toString().toLowerCase(), value);
	}

	/**
	 * @see java.util.Map#putAll(java.util.Map)
	 */
	@Override
	public void putAll(Map<? extends String, ? extends V> m) {
		Iterator<? extends String> iter = m.keySet().iterator();
		while (iter.hasNext()) {
			String key = iter.next();
			V value = m.get(key);
			this.put(key, value);
		}
	}
	
	/**
	 * @see java.util.Map#remove(java.lang.Object)
	 */
	public V remove(Object key) {
		return super.remove(key.toString().toLowerCase());
	}
}
