package jp.sourceforge.sxdbutils.types;

import java.sql.ResultSet;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.util.OthersUtils;

public class BooleanType extends AbstractValueType {
	private final boolean primitive;

	public BooleanType(boolean primitive) {
		this.primitive = primitive;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see dbutilsx.types.ValueType#getValue(java.sql.ResultSet, int)
	 */
	public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
		if (rset.getObject(columnIndex) == null)
			return primitive ? Boolean.FALSE : null;
		return OthersUtils.toBooleanObject(rset.getBoolean(columnIndex));
	}

	// protected int getSqlType() {
	// return Types.BOOLEAN;
	// }

}
