package jp.sourceforge.sxdbutils.types;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class BigDecimalType extends AbstractValueType {
	/*
	 * (non-Javadoc)
	 * 
	 * @see dbutilsx.types.ValueType#getValue(java.sql.ResultSet, int)
	 */
	public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
		return rset.getBigDecimal(columnIndex);
	}

	// protected int getSqlType() {
	// return Types.DECIMAL;
	// }
	public void bindValue(PreparedStatement pstmt, int parameterIndex, Object value) throws SQLException {
		pstmt.setBigDecimal(parameterIndex, (BigDecimal) value);

	}
}
