package jp.sourceforge.sxdbutils.rstable;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;

public interface ResultTableSupport {
	ResultColumnMetaData[] getColumnMetaDatas();

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の int として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	int getInt(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、 {@link Integer} として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	Integer getInteger(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の long として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	long getLong(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link Long}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	Long getLongObject(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の short として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	short getShort(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link Short}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	Short getShortObject(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の float として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	float getFloat(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link Float}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	Float getFloatObject(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の double として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	double getDouble(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link Double}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	Double getDoubleObject(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の byte として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	byte getByte(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link Byte}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	Byte getByteObject(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の boolean として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	boolean getBoolean(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link Boolean}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	Boolean getBooleanObject(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の char として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	char getChar(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link Character}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	Character getCharacter(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link BigDecimal}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	BigDecimal getBigDecimal(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link String}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	String getString(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、byte配列  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	byte[] getBytes(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link java.util.Date}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	java.util.Date getDate(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link java.sql.Date}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	java.sql.Date getSqlDate(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link Timestamp}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	Timestamp getTimestamp(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link Time}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	Time getTime(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、{@link Object}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnLabel カラム名
	 * @return
	 */
	Object getObject(int row, String columnLabel);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の int として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	int getInt(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、 {@link Integer} として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Integer getInteger(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の long として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	long getLong(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link Long}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Long getLongObject(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の short として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	short getShort(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link Short}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Short getShortObject(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の float として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	float getFloat(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link Float}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Float getFloatObject(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の double として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	double getDouble(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link Double}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Double getDoubleObject(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の byte として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	byte getByte(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link Byte}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Byte getByteObject(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の boolean として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	boolean getBoolean(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link Boolean}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Boolean getBooleanObject(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、Java プログラミング言語の char として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	char getChar(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link Character}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Character getCharacter(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link BigDecimal}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	BigDecimal getBigDecimal(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link String}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	String getString(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、byte配列  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	byte[] getBytes(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link java.util.Date}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	java.util.Date getDate(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link java.sql.Date}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	java.sql.Date getSqlDate(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link Timestamp}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Timestamp getTimestamp(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link Time}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Time getTime(int row, int columnIndex);

	/**
	 * 指定された行にある指定された列の値を、{@link Object}  として取得します。
	 * @param row 0から始まる行番号。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Object getObject(int row, int columnIndex);

}
