package jp.sourceforge.sxdbutils.rstable;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public interface ResultColumn {
	ResultColumnMetaData getColumnMetaData();

	Object getValue(ResultSet rs) throws SQLException;

	String getColumnName();

	int getColumnIndex();

	int getInt(Object[] rowdata);

	Integer getInteger(Object[] rowdata);

	long getLong(Object[] rowdata);

	Long getLongObject(Object[] rowdata);

	short getShort(Object[] rowdata);

	Short getShortObject(Object[] rowdata);

	float getFloat(Object[] rowdata);

	Float getFloatObject(Object[] rowdata);

	double getDouble(Object[] rowdata);

	Double getDoubleObject(Object[] rowdata);

	byte getByte(Object[] rowdata);

	Byte getByteObject(Object[] rowdata);

	boolean getBoolean(Object[] rowdata);

	Boolean getBooleanObject(Object[] rowdata);

	char getChar(Object[] rowdata);

	Character getCharacter(Object[] rowdata);

	BigDecimal getBigDecimal(Object[] rowdata);

	String getString(Object[] rowdata);

	byte[] getBytes(Object[] rowdata);

	java.util.Date getDate(Object[] rowdata);

	java.sql.Date getSqlDate(Object[] rowdata);

	Timestamp getTimestamp(Object[] rowdata);

	Time getTime(Object[] rowdata);
}
