package jp.sourceforge.sxdbutils.rstable;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class BasicResultRow implements ResultRow {
	final Object[] rowValues;
	final ResultColumnRepository columnRepository;

	public BasicResultRow(ResultColumnRepository columnRepository, Object[] rowValues) {
		this.columnRepository = columnRepository;
		this.rowValues = rowValues;
	}

	public ResultColumnMetaData[] getColumnMetaDatas() {
		ResultColumnMetaData[] result = new ResultColumnMetaData[columnRepository.size()];
		for (int i = 0; i < columnRepository.size(); i++) {
			result[i] = columnRepository.getResultColumn(i).getColumnMetaData();
		}
		return result;
	}

	/**
	 * @deprecated
	 */
	public ResultColumnMetaData[] getResultColumnMetaDatas() {
		return getColumnMetaDatas();
	}

	public BigDecimal getBigDecimal(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getBigDecimal(rowValues);
	}

	public BigDecimal getBigDecimal(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getBigDecimal(rowValues);
	}

	public boolean getBoolean(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getBoolean(rowValues);
	}

	public boolean getBoolean(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getBoolean(rowValues);
	}

	public Boolean getBooleanObject(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getBooleanObject(rowValues);
	}

	public Boolean getBooleanObject(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getBooleanObject(rowValues);
	}

	public byte getByte(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getByte(rowValues);
	}

	public byte getByte(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getByte(rowValues);
	}

	public Byte getByteObject(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getByteObject(rowValues);
	}

	public Byte getByteObject(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getByteObject(rowValues);
	}

	public byte[] getBytes(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getBytes(rowValues);

	}

	public byte[] getBytes(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getBytes(rowValues);
	}

	public char getChar(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getChar(rowValues);
	}

	public char getChar(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getChar(rowValues);
	}

	public Character getCharacter(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getCharacter(rowValues);
	}

	public Character getCharacter(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getCharacter(rowValues);
	}

	public Date getDate(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getDate(rowValues);
	}

	public Date getDate(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getDate(rowValues);
	}

	public double getDouble(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getDouble(rowValues);
	}

	public double getDouble(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getDouble(rowValues);
	}

	public Double getDoubleObject(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getDoubleObject(rowValues);
	}

	public Double getDoubleObject(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getDoubleObject(rowValues);
	}

	public float getFloat(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getFloat(rowValues);
	}

	public float getFloat(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getFloat(rowValues);
	}

	public Float getFloatObject(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getFloatObject(rowValues);
	}

	public Float getFloatObject(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getFloatObject(rowValues);
	}

	public int getInt(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getInt(rowValues);
	}

	public int getInt(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getInt(rowValues);
	}

	public Integer getInteger(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getInteger(rowValues);
	}

	public Integer getInteger(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getInteger(rowValues);
	}

	public long getLong(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getLong(rowValues);
	}

	public long getLong(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getLong(rowValues);
	}

	public Long getLongObject(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getLongObject(rowValues);
	}

	public Long getLongObject(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getLongObject(rowValues);
	}

	public short getShort(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getShort(rowValues);
	}

	public short getShort(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getShort(rowValues);
	}

	public Short getShortObject(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getShortObject(rowValues);
	}

	public Short getShortObject(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getShortObject(rowValues);
	}

	public java.sql.Date getSqlDate(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getSqlDate(rowValues);
	}

	public java.sql.Date getSqlDate(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getSqlDate(rowValues);
	}

	public String getString(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getString(rowValues);
	}

	public String getString(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getString(rowValues);
	}

	public Time getTime(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getTime(rowValues);
	}

	public Time getTime(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getTime(rowValues);
	}

	public Timestamp getTimestamp(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return col.getTimestamp(rowValues);
	}

	public Timestamp getTimestamp(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return col.getTimestamp(rowValues);
	}

	public Object getObject(int columnIndex) {
		ResultColumn col = columnRepository.getResultColumn(columnIndex);
		return rowValues[col.getColumnIndex()];
	}

	public Object getObject(String columnLabel) {
		ResultColumn col = columnRepository.getResultColumn(columnLabel);
		return rowValues[col.getColumnIndex()];
	}

}
