package jp.sourceforge.sxdbutils.query;

import java.util.Map;

import jp.sourceforge.sxdbutils.util.ColumnInfo;

public class MapQueryFactory implements QueryFactory<Map<String,Object>> {
	private final String sql;
	private final ColumnInfo[] columns;

	MapQueryFactory(String sql, ColumnInfo[] columns) {
		this.sql = sql;
		this.columns = columns;
	}

	public Query toQuery(Map<String,Object> map) {
		SimpleQueryBuilder builder = new SimpleQueryBuilder(this.sql);
		for (int i = 0; i < columns.length; i++) {
			if (!map.containsKey(columns[i].getColumnName())) {
				builder.bind(null);
				continue;
			}
			builder.bind(columns[i].getValueType().toBindParameterValue(map.get(columns[i].getColumnName())));
		}
		return builder.toQuery();
	}

	public String getSql() {
		return this.sql;
	}

	public Object[] toBindParameters(Map<String,Object> map) {
		Object[] params = new Object[columns.length];
		for (int i = 0; i < columns.length; i++) {
			if (!map.containsKey(columns[i].getColumnName())) {
				params[i] = null;
				continue;
			}
			params[i] = columns[i].getValueType().toBindParameterValue(map.get(columns[i].getColumnName()));
		}
		return params;
	}

}
