package jp.sourceforge.sxdbutils.processors;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.ColumnInfo;
import jp.sourceforge.sxdbutils.util.JdbcMetaUtil;

/**
 * 
 * @author chinpei
 * 
 */
public class MapRowProcessor implements SxRowProcessor<Map<String, Object>> {

	private ColumnInfo[] columnInfos;

	/**
	 * 初期化。
	 */
	public void init(ResultSetMetaData rsmd) throws SQLException {

		List<ColumnInfo> list = new ArrayList<ColumnInfo>();

		for (int i = 0, columnIndex = 1; i < rsmd.getColumnCount(); i++, columnIndex++) {
			String columnName = JdbcMetaUtil.getColumnName(rsmd, columnIndex);
			ColumnInfo columnInfo = new ColumnInfo(columnName, getValueType(rsmd.getColumnType(columnIndex)));
			list.add(columnInfo);
		}
		this.columnInfos = (ColumnInfo[]) list.toArray(new ColumnInfo[list.size()]);

	}

	/**
	 * カラム名をキーにしたMapを返します。
	 */
	public Map<String, Object> process(ResultSet rs) throws SQLException {
		Map<String, Object> map = new CaseInsensitiveHashMap<Object>();
		for (int i = 0; i < columnInfos.length; i++) {
			ColumnInfo columnInfo = columnInfos[i];
			map.put(columnInfo.getColumnName(), columnInfo.getValueType().getValue(rs, i + 1));
		}
		return map;
	}

	protected ValueType getValueType(int sqlType) {
		return TypeMappings.getValueType(sqlType);
	}
}
