package jp.sourceforge.sxdbutils.processors;

import java.util.Map;

import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.meta.AttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.PropertyAttributeDescpritor;

/**
 * Beanにマッピングする {@link SxRowProcessor}。 カラム名とプロパティ名の名前が、 {@link NameMapping}
 * によって一致したものがマッピングされます。 デフォルトでは、カラム名でマッピングされます。
 * 
 * @author chinpei
 * 
 */
public class BeanRowProcessor<E> extends AttributeRowProcessor<E> {

	public BeanRowProcessor(Class<E> clazz, NameMapping nameMapping) {
		super(clazz, nameMapping);
	}

	public BeanRowProcessor(Class<E> beanClass) {
		super(beanClass);
	}

	protected void putDescriptorToMap(Class<E> clazz, Map<String, AttributeDescpriotr> descriptorMap) {
		PropertyAttributeDescpritor.putDescriptorToMap(clazz, descriptorMap);
	}

	/**
	 * マッピング対象クラスを返します。
	 * 
	 * @return
	 */
	public Class<E> getBeanClass() {
		return baseClass;
	}
}
