package jp.sourceforge.sxdbutils.mapping;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;

/**
 * コンストラクタにkeyにプロパティ名を、valueにカラム名をセットしたMapを渡すことができる {@link NameMapping} です。
 * 
 * @author chinpei
 * 
 */
public class OverwriteNameMapping implements NameMapping {

	private static final NameMapping DEFAULT_COMVERSION = new ColumnNameMapping();

	protected final Map<String,String> propertyToColumnMap;
	protected final Map<String,String> columnToPropertyMap = this.createIntermediateMap();

	protected final NameMapping defaultNameMapping;

	public OverwriteNameMapping(Map<String,String> propertyToColumnMap) {
		this(propertyToColumnMap, DEFAULT_COMVERSION);
	}

	public OverwriteNameMapping(Map<String,String> propertyToColumnMap, NameMapping defaultNameMapping) {
		this.propertyToColumnMap = new HashMap<String,String>(propertyToColumnMap);
		for (Iterator<Map.Entry<String,String>> iterator = this.propertyToColumnMap.entrySet().iterator(); iterator.hasNext();) {
			Map.Entry<String,String> entry =  iterator.next();
			columnToPropertyMap.put(entry.getValue(), entry.getKey());
		}
		this.defaultNameMapping = defaultNameMapping;
	}

	public String toIntermediateNameFromAttrName(String bindObjectName) {
		return (this.propertyToColumnMap.containsKey(bindObjectName)) ? bindObjectName : defaultNameMapping
				.toIntermediateNameFromAttrName(bindObjectName);
	}

	public String toColumnNameFromAttrName(String bindObjectName) {
		return (this.propertyToColumnMap.containsKey(bindObjectName)) ? this.propertyToColumnMap
				.get(bindObjectName) : defaultNameMapping.toColumnNameFromAttrName(bindObjectName);
	}

	public final Map<String, String> createIntermediateMap() {
		return new CaseInsensitiveHashMap<String>();
	}

	public String toIntermediateNameFromColumnName(String columnName) {
		String name = (String) columnToPropertyMap.get(columnName);
		return name == null ? defaultNameMapping.toIntermediateNameFromColumnName(columnName) : name;
	}
}
