package jp.sourceforge.sxdbutils.extras.dao;

import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.mapping.ColumnNameMapping;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.processors.FieldRowProcessor;

public abstract class AbstractFieldSelectTemplate<E> extends AbstractAttributeSelectTemplate<E> {
	protected abstract Class<E> getEntityClass();

	protected NameMapping getNameMapping() {
		return new ColumnNameMapping();
	}

	@Override
	protected <X extends E> SxRowProcessor<X> createRowProcessor(Class<X> entityClass) {
		return new FieldRowProcessor<X>(entityClass, getNameMapping());
	}

}
