package jp.sourceforge.sxdbutils.extras.dao;

import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.mapping.ColumnNameMapping;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.processors.BeanRowProcessor;
import jp.sourceforge.sxdbutils.query.BeanQueryFactoryBuilder;

public abstract class AbstractBeanCLUDTemplate<E> extends AbstractAttributeCLUDTemplate<E, BeanQueryFactoryBuilder<E>> {
	protected abstract Class<E> getEntityClass();

	protected NameMapping getNameMapping() {
		return new ColumnNameMapping();
	}

	@Override
	protected <X extends E> SxRowProcessor<X> createRowProcessor(Class<X> entityClass) {
		return new BeanRowProcessor<X>(entityClass, getNameMapping());
	}

	@Override
	protected BeanQueryFactoryBuilder<E> createQueryFactoryBuilder() {
		return new BeanQueryFactoryBuilder<E>(getEntityClass(), getNameMapping());
	}

}
