package jp.sourceforge.sxdbutils.extras.dao;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import jp.sourceforge.sxdbutils.SxQueryRunner;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.handlers.ListHandler;
import jp.sourceforge.sxdbutils.handlers.SingleHandler;
import jp.sourceforge.sxdbutils.query.Query;

public abstract class AbstractAttributeSelectTemplate<E> {

	protected abstract Connection getConnection() throws SQLException;

	protected abstract <X extends E> SxRowProcessor<X> createRowProcessor(Class<X> entityClass);

	protected <X extends E> SingleHandler<X> createSingleHandler(Class<X> entityClass) {
		return new SingleHandler<X>(createRowProcessor(entityClass));
	}

	protected <X extends E> ListHandler<X> createListHandler(Class<X> entityClass) {
		return new ListHandler<X>(createRowProcessor(entityClass));
	}

	protected <X extends E> X executeQueryToEntity(Query query, Class<X> entityClass) throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, createSingleHandler(entityClass));
	}

	protected <X extends E> List<X> executeQueryToEntityList(Query query, Class<X> entityClass) throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, createListHandler(entityClass));
	}


}
