package jp.sourceforge.sxdbutils;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public interface SxRowProcessor<S> {
	/**
	 * SQLの結果が帰ってきた最初に一度だけ呼ばれます。
	 * @param rsmd
	 * @throws SQLException
	 */
	void init(ResultSetMetaData rsmd) throws SQLException;
	/**
	 * 1行を処理する。
	 * @param rs
	 * @return
	 * @throws SQLException
	 */
	S process(ResultSet rs) throws SQLException;
}
