/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtil {
    private static final Object[] NULL_OBJECT_ARRAY = new Object[0];

    private ReflectionUtil() {
    }

    public static Object invoke(Object obj, Method method) {
        return ReflectionUtil.invoke(obj, method, NULL_OBJECT_ARRAY);
    }

    public static Object invoke(Object obj, Method method, Object arg1) {
        return ReflectionUtil.invoke(obj, method, new Object[]{arg1});
    }

    public static Object invoke(Object obj, Method method, Object arg1, Object arg2) {
        return ReflectionUtil.invoke(obj, method, new Object[]{arg1, arg2});
    }

    public static Object invoke(Object obj, Method method, Object arg1, Object arg2, Object arg3) {
        return ReflectionUtil.invoke(obj, method, new Object[]{arg1, arg2, arg3});
    }

    public static Object invoke(Object obj, Method method, Object[] args) {
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeQuietly(Object obj, Method method, Object arg1) {
        try {
            return ReflectionUtil.invoke(obj, method, new Object[]{arg1});
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object invokeQuietly(Object obj, Method method, Object arg1, Object arg2) {
        try {
            return ReflectionUtil.invokeQuietly(obj, method, new Object[]{arg1, arg2});
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object invokeQuietly(Object obj, Method method, Object arg1, Object arg2, Object arg3) {
        try {
            return ReflectionUtil.invokeQuietly(obj, method, new Object[]{arg1, arg2, arg3});
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object invokeQuietly(Object obj, Method method, Object[] args) {
        try {
            return method.invoke(obj, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object newInstance(Class<?> type) {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object newInstance(Class<?> type, Object[] args) {
        if (args.length == 0) {
            return ReflectionUtil.newInstance(type);
        }
        try {
            Class[] argTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object object = args[i];
                argTypes[i] = object == null ? null : object.getClass();
            }
            Constructor<?>[] constructors = type.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constructor = constructors[i];
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != argTypes.length) continue;
                int matchCount = 0;
                for (int j = 0; j < parameterTypes.length; ++j) {
                    Class<?> parameterType = parameterTypes[j];
                    if (!ReflectionUtil.isCompatibleType(args[j], parameterType)) continue;
                    ++matchCount;
                }
                if (matchCount == 0 || matchCount != parameterTypes.length) continue;
                return constructor.newInstance(args);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isCompatibleType(Object value, Class<?> type) {
        if (value == null || type.isInstance(value)) {
            return true;
        }
        if (type.equals(Integer.TYPE) && Integer.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Long.TYPE) && Long.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Double.TYPE) && Double.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Float.TYPE) && Float.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Short.TYPE) && Short.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Byte.TYPE) && Byte.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Character.TYPE) && Character.class.isInstance(value)) {
            return true;
        }
        return type.equals(Boolean.TYPE) && Boolean.class.isInstance(value);
    }

    public static PropertyDescriptor[] propertyDescriptors(Class<?> beanClass) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
            return beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPublicStaticFinalString(Field field) {
        return field.getType().equals(String.class) && ReflectionUtil.isPublicStaticFinal(field);
    }

    public static boolean isPublicStaticFinalBoolean(Field field) {
        return field.getType().equals(Boolean.TYPE) && ReflectionUtil.isPublicStaticFinal(field);
    }

    public static boolean isPublicStaticFinalInt(Field field) {
        return field.getType().equals(Integer.TYPE) && ReflectionUtil.isPublicStaticFinal(field);
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers);
    }

    public static String getString(Field field) {
        try {
            return (String)field.get(null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean getBoolean(Field field) {
        try {
            return field.getBoolean(null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getInt(Field field) {
        try {
            return field.getInt(null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getLong(Field field) {
        try {
            return field.getLong(null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getObject(Object object, Field field) {
        try {
            return field.get(object);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setObject(Field field, Object object, Object value) {
        try {
            field.set(object, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static String removalSuffixFieldName(Field field, String suffix) {
        String fieldName = field.getName();
        return fieldName.substring(0, fieldName.lastIndexOf(suffix));
    }
}

