/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.query;

import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryBuilder;
import jp.sourceforge.sxdbutils.query.SimpleQueryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInsertBuilder
implements QueryBuilder {
    private final String tableName;
    private Map<String, Object> entries = new LinkedHashMap<String, Object>();

    public SimpleInsertBuilder(String tableName) {
        this.tableName = tableName;
    }

    public SimpleInsertBuilder add(String columnName, Object value) {
        this.entries.put(columnName, value);
        return this;
    }

    public SimpleInsertBuilder addAll(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.entries.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public SimpleInsertBuilder add(String columnName, int value) {
        return this.add(columnName, new Integer(value));
    }

    public SimpleInsertBuilder add(String columnName, long value) {
        return this.add(columnName, new Long(value));
    }

    public SimpleInsertBuilder add(String columnName, double value) {
        return this.add(columnName, new Double(value));
    }

    public SimpleInsertBuilder add(String columnName, float value) {
        return this.add(columnName, new Float(value));
    }

    public SimpleInsertBuilder add(String columnName, short value) {
        return this.add(columnName, new Short(value));
    }

    public SimpleInsertBuilder add(String columnName, byte value) {
        return this.add(columnName, new Byte(value));
    }

    public SimpleInsertBuilder add(String columnName, char value) {
        return this.add(columnName, String.valueOf(value));
    }

    @Override
    public Query toQuery() {
        SimpleQueryBuilder builder = new SimpleQueryBuilder(256);
        builder.append("insert into ").append(this.tableName).append(" (");
        StringBuffer valuesPart = new StringBuffer(" values( ");
        boolean flg = false;
        for (Map.Entry<String, Object> entry : this.entries.entrySet()) {
            if (flg) {
                builder.append(',');
                valuesPart.append(',');
            }
            flg = true;
            builder.append(entry.getKey()).bind(entry.getValue());
            valuesPart.append('?');
        }
        builder.append(" ) ").append(valuesPart).append(")");
        return builder.toQuery();
    }
}

