/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.query;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jp.sourceforge.sxdbutils.util.QueryUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Query
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final StringBuffer sql;
    protected final List<Object> parameters;

    public Query(String sql, List<Object> parameters) {
        this.sql = new StringBuffer(sql);
        this.parameters = parameters;
    }

    public Query join(Query other) {
        Query result = new Query(this.sql.toString(), new ArrayList<Object>(this.parameters));
        result.sql.append(other.sql);
        result.parameters.addAll(other.parameters);
        return result;
    }

    public String getSql() {
        return this.sql.toString();
    }

    public Object[] getParameters() {
        return this.parameters.toArray();
    }

    public String literal() {
        if (QueryUtil.isBlank(this.sql)) {
            return "";
        }
        StringBuffer builder = new StringBuffer(this.sql.toString());
        for (int i = 0; i < this.parameters.size(); ++i) {
            QueryUtil.replace(builder, "?", Query.toNativeParameter(this.parameters.get(i)));
        }
        return builder.toString();
    }

    public String toString() {
        StringBuffer builder = new StringBuffer(this.sql.toString());
        builder.append('\n');
        builder.append("==parameter====================\n");
        for (int i = 0; i < this.parameters.size(); ++i) {
            Object parameter = this.parameters.get(i);
            DecimalFormat format = new DecimalFormat("000");
            builder.append(format.format(i));
            builder.append('\t');
            if (parameter == null) {
                builder.append("null\n");
                continue;
            }
            if (parameter.getClass().isAssignableFrom(byte[].class)) {
                builder.append("<<binary>>\n");
                continue;
            }
            builder.append(parameter.getClass().getName() + "\t#" + parameter).append("\n");
        }
        builder.append("====================parameter==\n");
        return builder.toString();
    }

    private static String toNativeParameter(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof Number) {
            return obj.toString();
        }
        if (obj instanceof Date) {
            return "'" + QueryUtil.sqlDateFormat((Date)obj) + "'";
        }
        if (obj instanceof Calendar) {
            return "'" + QueryUtil.sqlDateFormat((Calendar)obj) + "'";
        }
        if (obj.getClass().isAssignableFrom(byte[].class)) {
            return "<<binary>>";
        }
        return "'" + obj + "'";
    }
}

