/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.query;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.meta.BasicPersistenceEntry;
import jp.sourceforge.sxdbutils.meta.FieldAttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.PersistenceEntry;
import jp.sourceforge.sxdbutils.query.AttributeQueryFactoryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldQueryFactoryBuilder<E>
extends AttributeQueryFactoryBuilder<E> {
    public FieldQueryFactoryBuilder(Class<E> baseClass) {
        super(baseClass);
    }

    public FieldQueryFactoryBuilder(Class<E> baseClass, NameMapping nameMapping) {
        super(baseClass, nameMapping);
    }

    public FieldQueryFactoryBuilder<E> excludeColumn(String excludeColumn) {
        this.excludeColumns.add(excludeColumn.toLowerCase());
        return this;
    }

    public FieldQueryFactoryBuilder<E> excludeColumns(String[] excludeColumns) {
        for (int i = 0; i < excludeColumns.length; ++i) {
            this.excludeColumn(excludeColumns[i]);
        }
        return this;
    }

    public FieldQueryFactoryBuilder<E> excludeColumns(List<String> excludeColumns) {
        for (int i = 0; i < excludeColumns.size(); ++i) {
            this.excludeColumn(excludeColumns.get(i));
        }
        return this;
    }

    public FieldQueryFactoryBuilder<E> tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public FieldQueryFactoryBuilder<E> versionColumnName(String versionColumnName) {
        this.versionColumnName = versionColumnName;
        return this;
    }

    public FieldQueryFactoryBuilder<E> columnType(String columnName, int sqlType) {
        this.columnTypeMap.put(columnName.toLowerCase(), new Integer(sqlType));
        return this;
    }

    public FieldQueryFactoryBuilder<E> whereKeyColumn(String columnNames) {
        if (this.whereKeyColumnSet == null) {
            this.whereKeyColumnSet = new LinkedHashSet();
        }
        this.whereKeyColumnSet.add(columnNames.toLowerCase());
        return this;
    }

    @Override
    protected PersistenceEntry[] toPersistenceEntries() {
        Field[] fields = this.baseClass.getFields();
        ArrayList<BasicPersistenceEntry> persistenceEntries = new ArrayList<BasicPersistenceEntry>();
        for (int i = 0; i < fields.length; ++i) {
            FieldAttributeDescpriotr attributeDescpriotr = new FieldAttributeDescpriotr(fields[i]);
            String columnName = this.nameMapping.toColumnNameFromAttrName(attributeDescpriotr.getName());
            if (this.excludeColumns.contains(columnName.toLowerCase())) continue;
            Integer sqlType = (Integer)this.columnTypeMap.get(columnName.toLowerCase());
            ValueType valueType = this.getValueType(attributeDescpriotr, sqlType);
            BasicPersistenceEntry entry = new BasicPersistenceEntry(columnName, valueType, attributeDescpriotr);
            persistenceEntries.add(entry);
        }
        return persistenceEntries.toArray(new PersistenceEntry[persistenceEntries.size()]);
    }
}

