/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.processors;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.ColumnInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapRowProcessor
implements SxRowProcessor<Map<String, Object>> {
    private ColumnInfo[] columnInfos;

    @Override
    public void init(ResultSetMetaData rsmd) throws SQLException {
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        int i = 0;
        int columnIndex = 1;
        while (i < rsmd.getColumnCount()) {
            ColumnInfo columnInfo = new ColumnInfo(rsmd.getColumnLabel(columnIndex), this.getValueType(rsmd.getColumnType(columnIndex)));
            list.add(columnInfo);
            ++i;
            ++columnIndex;
        }
        this.columnInfos = list.toArray(new ColumnInfo[list.size()]);
    }

    @Override
    public Map<String, Object> process(ResultSet rs) throws SQLException {
        CaseInsensitiveHashMap<Object> map = new CaseInsensitiveHashMap<Object>();
        for (int i = 0; i < this.columnInfos.length; ++i) {
            ColumnInfo columnInfo = this.columnInfos[i];
            map.put(columnInfo.getColumnName(), columnInfo.getValueType().getValue(rs, i + 1));
        }
        return map;
    }

    protected ValueType getValueType(int sqlType) {
        return TypeMappings.getValueType(sqlType);
    }
}

