/**
 * 
 */
package jp.sourceforge.sxdbutils.rstable;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;

/**
 * 結果セットの１行を表すオブジェクトです。
 * @author chinpei
 *
 */
public interface ResultRow {

	ResultColumnMetaData[] getResultColumnMetaDatas();

	/**
	 * 指定された列の値を、Java プログラミング言語の int として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	int getInt(String columnLabel);

	/**
	 * 指定された列の値を、 {@link Integer} として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	Integer getInteger(String columnLabel);

	/**
	 * 指定された列の値を、Java プログラミング言語の long として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	long getLong(String columnLabel);

	/**
	 * 指定された列の値を、{@link Long}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	Long getLongObject(String columnLabel);

	/**
	 * 指定された列の値を、Java プログラミング言語の short として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	short getShort(String columnLabel);

	/**
	 * 指定された列の値を、{@link Short}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	Short getShortObject(String columnLabel);

	/**
	 * 指定された列の値を、Java プログラミング言語の float として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	float getFloat(String columnLabel);

	/**
	 * 指定された列の値を、{@link Float}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	Float getFloatObject(String columnLabel);

	/**
	 * 指定された列の値を、Java プログラミング言語の double として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	double getDouble(String columnLabel);

	/**
	 * 指定された列の値を、{@link Double}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	Double getDoubleObject(String columnLabel);

	/**
	 * 指定された列の値を、Java プログラミング言語の byte として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	byte getByte(String columnLabel);

	/**
	 * 指定された列の値を、{@link Byte}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	Byte getByteObject(String columnLabel);

	/**
	 * 指定された列の値を、Java プログラミング言語の boolean として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	boolean getBoolean(String columnLabel);

	/**
	 * 指定された列の値を、{@link Boolean}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	Boolean getBooleanObject(String columnLabel);

	/**
	 * 指定された列の値を、Java プログラミング言語の char として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	char getChar(String columnLabel);

	/**
	 * 指定された列の値を、{@link Character}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	Character getCharacter(String columnLabel);

	/**
	 * 指定された列の値を、{@link BigDecimal}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	BigDecimal getBigDecimal(String columnLabel);

	/**
	 * 指定された列の値を、{@link String}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	String getString(String columnLabel);

	/**
	 * 指定された列の値を、byte配列  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	byte[] getBytes(String columnLabel);

	/**
	 * 指定された列の値を、{@link java.util.Date}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	java.util.Date getDate(String columnLabel);

	/**
	 * 指定された列の値を、{@link java.sql.Date}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	java.sql.Date getSqlDate(String columnLabel);

	/**
	 * 指定された列の値を、{@link Timestamp}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	Timestamp getTimestamp(String columnLabel);

	/**
	 * 指定された列の値を、{@link Time}  として取得します。
	 * @param columnLabel カラム名
	 * @return
	 */
	Time getTime(String columnLabel);

	/**
	 * 指定された列の値を、{@link Object}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Object getObject(String columnLabel);

	/**
	 * 指定された列の値を、Java プログラミング言語の int として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	int getInt(int columnIndex);

	/**
	 * 指定された列の値を、 {@link Integer} として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Integer getInteger(int columnIndex);

	/**
	 * 指定された列の値を、Java プログラミング言語の long として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	long getLong(int columnIndex);

	/**
	 * 指定された列の値を、{@link Long}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Long getLongObject(int columnIndex);

	/**
	 * 指定された列の値を、Java プログラミング言語の short として取得します。

	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	short getShort(int columnIndex);

	/**
	 * 指定された列の値を、{@link Short}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Short getShortObject(int columnIndex);

	/**
	 * 指定された列の値を、Java プログラミング言語の float として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	float getFloat(int columnIndex);

	/**
	 * 指定された列の値を、{@link Float}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Float getFloatObject(int columnIndex);

	/**
	 * 指定された列の値を、Java プログラミング言語の double として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	double getDouble(int columnIndex);

	/**
	 * 指定された列の値を、{@link Double}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Double getDoubleObject(int columnIndex);

	/**
	 * 指定された列の値を、Java プログラミング言語の byte として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	byte getByte(int columnIndex);

	/**
	 * 指定された列の値を、{@link Byte}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Byte getByteObject(int columnIndex);

	/**
	 * 指定された列の値を、Java プログラミング言語の boolean として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	boolean getBoolean(int columnIndex);

	/**
	 * 指定された列の値を、{@link Boolean}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Boolean getBooleanObject(int columnIndex);

	/**
	 * 指定された列の値を、Java プログラミング言語の char として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	char getChar(int columnIndex);

	/**
	 * 指定された列の値を、{@link Character}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Character getCharacter(int columnIndex);

	/**
	 * 指定された列の値を、{@link BigDecimal}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	BigDecimal getBigDecimal(int columnIndex);

	/**
	 * 指定された列の値を、{@link String}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	String getString(int columnIndex);

	/**
	 * 指定された列の値を、byte配列  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	byte[] getBytes(int columnIndex);

	/**
	 * 指定された列の値を、{@link java.util.Date}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	java.util.Date getDate(int columnIndex);

	/**
	 * 指定された列の値を、{@link java.sql.Date}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	java.sql.Date getSqlDate(int columnIndex);

	/**
	 * 指定された列の値を、{@link Timestamp}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Timestamp getTimestamp(int columnIndex);

	/**
	 * 指定された列の値を、{@link Time}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Time getTime(int columnIndex);

	/**
	 * 指定された列の値を、{@link Object}  として取得します。
	 * @param columnIndex 最初の列は 0、2 番目の列は 1、... となる 
	 * @return
	 */
	Object getObject(int columnIndex);

}