package jp.sourceforge.sxdbutils.query;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.sourceforge.sxdbutils.util.OthersUtils;
import jp.sourceforge.sxdbutils.util.QueryUtil;

/**
 * UPDATE文の {@link Query}を作成するためのビルダーです。
 * 
 * @author chinpei
 * 
 */
public class SimpleUpdateBuilder implements QueryBuilder {
	private final String tableName;
	private Map<String, Object> updateColumnMap = new LinkedHashMap<String, Object>();
	private Map<String, Object> whereColumnMap = new LinkedHashMap<String, Object>();

	private String versionColumnName;
	private Object versionColumnValue;

	public SimpleUpdateBuilder addUpdateColumn(String columnName, Object value) {
		updateColumnMap.put(columnName, value);
		return this;
	}

	public SimpleUpdateBuilder addUpdateColumn(Map<String, Object> columnMap) {
		updateColumnMap.putAll(columnMap);
		return this;
	}

	public SimpleUpdateBuilder addWhereColumn(String columnName, Object value) {
		whereColumnMap.put(columnName, value);
		return this;
	}

	public SimpleUpdateBuilder setVersionColumn(String columnName, Object value) {
		versionColumnName = columnName;
		versionColumnValue = value;
		return this;
	}

	public SimpleUpdateBuilder(String tableName) {
		this.tableName = tableName;
	}

	public Query toQuery() {
		SimpleQueryBuilder builder = new SimpleQueryBuilder(256);
		builder.append("update ").append(tableName).append(" set ");
		boolean colflg = false;
		for (Iterator<Map.Entry<String, Object>> iterator = updateColumnMap.entrySet().iterator(); iterator.hasNext();) {
			Map.Entry<String, Object> entry = iterator.next();

			if (versionColumnName != null && versionColumnName.equalsIgnoreCase((String) entry.getKey()))
				continue;

			if (colflg)
				builder.append(',');
			colflg = true;
			builder.append((String) entry.getKey()).append("=?").bind(entry.getValue());
		}
		if (OthersUtils.isNotEmpty(versionColumnName)) {
			if (colflg)
				builder.append(',');
			builder.append(versionColumnName).append("=?").bind(QueryUtil.getNextVersion(versionColumnValue));
		}

		// ---------------where
		builder.append(" where ");
		boolean whereflg = false;
		for (Iterator<Map.Entry<String, Object>> iterator = whereColumnMap.entrySet().iterator(); iterator.hasNext();) {
			Map.Entry<String, Object> entry = iterator.next();

			if (whereflg)
				builder.append(" and ");
			whereflg = true;
			builder.append((String) entry.getKey()).append("=?").bind(entry.getValue());
		}
		// version
		if (OthersUtils.isNotEmpty(versionColumnName) && versionColumnValue != null) {
			if (whereflg)
				builder.append(" and ");
			builder.append(versionColumnName).append("=?").bind(versionColumnValue);
		}

		return builder.toQuery();
	}
}
