package jp.sourceforge.sxdbutils.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/**
 * Queryを作るためのビルダーです。
 * @author chinpei
 *
 */
public class SimpleQueryBuilder implements QueryBuilder {

	private StringBuffer sqlBase;
	private List<Object> parameters = new ArrayList<Object>();

	public SimpleQueryBuilder(String sql) {
		this.sqlBase = new StringBuffer(sql);
	}

	public SimpleQueryBuilder(int capacity) {
		this.sqlBase = new StringBuffer(capacity);
	}

	public SimpleQueryBuilder() {
	}

	public SimpleQueryBuilder(SimpleQueryBuilder builder) {
		this.append(builder);
	}

	public SimpleQueryBuilder(Query query) {
		append(query);
	}

	public SimpleQueryBuilder setSql(StringBuffer sql) {
		this.sqlBase = sql;
		return this;
	}

	public SimpleQueryBuilder setSql(String sql) {
		this.sqlBase = new StringBuffer(sql);
		return this;
	}

	public SimpleQueryBuilder append(String sql) {
		if (this.sqlBase == null)
			this.sqlBase = new StringBuffer();
		sqlBase.append(sql);
		return this;
	}

	public SimpleQueryBuilder append(char c) {
		if (this.sqlBase == null)
			this.sqlBase = new StringBuffer();
		sqlBase.append(c);
		return this;
	}

	public SimpleQueryBuilder append(StringBuffer sqlbuffer) {
		if (sqlbuffer == null)
			return this;
		else
			return append(sqlbuffer.toString());
	}

	public SimpleQueryBuilder append(SimpleQueryBuilder builder) {
		this.append(builder.sqlBase);
		this.bindAll(builder.parameters);
		return this;
	}

	public SimpleQueryBuilder append(QueryBuilder builder) {
		return append(builder.toQuery());
	}

	public SimpleQueryBuilder append(Query query) {
		this.append(query.getSql());
		Object[] params = query.getParameters();
		for (int i = 0; i < params.length; i++) {
			this.bind(params[i]);
		}
		return this;
	}

	public SimpleQueryBuilder append(String sql, Object param) {
		return this.append(sql, new Object[] { param });
	}

	public SimpleQueryBuilder append(String sql, Object param1, Object param2) {
		return this.append(sql, new Object[] { param1, param2 });
	}

	public SimpleQueryBuilder append(String sql, Object param1, Object param2, Object param3) {
		return this.append(sql, new Object[] { param1, param2, param3 });
	}

	public SimpleQueryBuilder append(String sql, Object param1, Object param2, Object param3, Object param4) {
		return this.append(sql, new Object[] { param1, param2, param3, param4 });
	}

	public SimpleQueryBuilder append(String sql, Object[] params) {
		if (this.sqlBase == null)
			this.sqlBase = new StringBuffer();
		sqlBase.append(sql);
		this.bindAll(params);
		return this;
	}

	public SimpleQueryBuilder insert(int offset, String sql) {
		if (this.sqlBase == null)
			this.sqlBase = new StringBuffer();
		sqlBase.insert(offset, sql);
		return this;
	}

	public SimpleQueryBuilder insert(int offset, StringBuffer sql) {
		if (sql == null)
			return this;
		else
			return insert(offset, sql.toString());
	}

	public SimpleQueryBuilder bind(Object value) {
		parameters.add(value);
		return this;
	}

	public SimpleQueryBuilder bindAll(Collection<Object> params) {
		for (Iterator<Object> iterator = params.iterator(); iterator.hasNext();) {
			this.bind(iterator.next());
		}
		return this;
	}

	public SimpleQueryBuilder bindAll(Object[] params) {
		for (int i = 0; i < params.length; i++) {
			this.bind(params[i]);
		}
		return this;
	}

	public String getSql() {
		if (sqlBase == null)
			return null;
		return sqlBase.toString();
	}

	public Query toQuery() {
		if (sqlBase == null) {
			return new Query("", parameters);
		}
		return new Query(sqlBase.toString(), parameters);
	}

}
