package jp.sourceforge.sxdbutils.tiger.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.sxdbutils.tiger.SxResultSetHandler;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;

/**
 * 複数行を処理するハンドラです。
 * 
 * @author chinpei
 * 
 */
public class ListHandler<S> implements SxResultSetHandler<List<S>> {

	protected final SxRowProcessor<S> processor;

	public ListHandler(SxRowProcessor<S> processor) {
		this.processor = processor;
	}

	protected SxRowProcessor<S> getProcessor() {
		if (processor == null) {
			throw new IllegalStateException("SxRowProcessorが指定されていません。"
					+ "引数なしのコンストラクタを使用する場合、"
					+ "必ずgetProcessorメソッドをオーバーライドしてください。");
		}
		return this.processor;
	}

	public List<S> handle(ResultSet rs) throws SQLException {
		List<S> rows = createList();
		if (rs.next()) {
			SxRowProcessor<S> proc = getProcessor();
			proc.init(rs.getMetaData());
			do {
				rows.add(proc.process(rs));
			} while (rs.next());
		}
		return rows;
	}

	List<S> createList() {
		return new ArrayList<S>();
	}

}
