/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.template.AbstractDeleteTemplate;
import jp.sourceforge.sxdbutils.template.AbstractInsertTemplate;
import jp.sourceforge.sxdbutils.template.AbstractSelectTemplate;
import jp.sourceforge.sxdbutils.template.AbstractUpdateTemplate;
import jp.sourceforge.sxdbutils.template.CrudTemplate;
import jp.sourceforge.sxdbutils.template.DeleteTemplate;
import jp.sourceforge.sxdbutils.template.InsertTemplate;
import jp.sourceforge.sxdbutils.template.SelectTemplate;
import jp.sourceforge.sxdbutils.template.UpdateTemplate;

public abstract class AbstractCrudTemplate
implements CrudTemplate {
    protected final SelectTemplate selectTemplate = new SelectTemplateImpl();
    protected final InsertTemplate insertTemplate;
    protected final UpdateTemplate updateTemplate;
    protected final DeleteTemplate deleteTemplate;

    protected abstract Connection getConnection() throws SQLException;

    protected abstract Class getEntityClass();

    protected abstract SxRowProcessor createRowProcessor(Class var1);

    public AbstractCrudTemplate(QueryFactory insertFactory, QueryFactory updateFactory, QueryFactory deleteFactory) {
        this.insertTemplate = new InsertTemplateImpl(insertFactory);
        this.updateTemplate = new UpdateTemplateImpl(updateFactory);
        this.deleteTemplate = new DeleteTemplateImpl(deleteFactory);
    }

    public int[] delete(Collection entities) throws SQLException {
        return this.deleteTemplate.delete(entities);
    }

    public int delete(Object entity) throws SQLException {
        return this.deleteTemplate.delete(entity);
    }

    public int[] deleteBatch(Collection entities) throws SQLException {
        return this.deleteTemplate.deleteBatch(entities);
    }

    public int insert(Object entity) throws SQLException {
        return this.insertTemplate.insert(entity);
    }

    public int[] insert(Collection entities) throws SQLException {
        return this.insertTemplate.insert(entities);
    }

    public int[] insertBatch(Collection entities) throws SQLException {
        return this.insertTemplate.insertBatch(entities);
    }

    public Object executeQueryToEntity(Query query, Class entityClass) throws SQLException {
        return this.selectTemplate.executeQueryToEntity(query, entityClass);
    }

    public Object executeQueryToEntity(Query query) throws SQLException {
        return this.selectTemplate.executeQueryToEntity(query);
    }

    public List executeQueryToEntityList(Query query, Class entityClass) throws SQLException {
        return this.selectTemplate.executeQueryToEntityList(query, entityClass);
    }

    public List executeQueryToEntityList(Query query) throws SQLException {
        return this.selectTemplate.executeQueryToEntityList(query);
    }

    public int[] update(Collection entities) throws SQLException {
        return this.updateTemplate.update(entities);
    }

    public int update(Object entity) throws SQLException {
        return this.updateTemplate.update(entity);
    }

    public int[] updateBatch(Collection entities) throws SQLException {
        return this.updateTemplate.updateBatch(entities);
    }

    protected class SelectTemplateImpl
    extends AbstractSelectTemplate {
        protected SelectTemplateImpl() {
        }

        protected SxRowProcessor createRowProcessor(Class entityClass) {
            return AbstractCrudTemplate.this.createRowProcessor(entityClass);
        }

        protected Class getEntityClass() {
            return AbstractCrudTemplate.this.getEntityClass();
        }

        protected Connection getConnection() throws SQLException {
            return AbstractCrudTemplate.this.getConnection();
        }
    }

    protected class DeleteTemplateImpl
    extends AbstractDeleteTemplate {
        public DeleteTemplateImpl(QueryFactory deleteFactory) {
            super(deleteFactory);
        }

        protected Connection getConnection() throws SQLException {
            return AbstractCrudTemplate.this.getConnection();
        }
    }

    protected class UpdateTemplateImpl
    extends AbstractUpdateTemplate {
        public UpdateTemplateImpl(QueryFactory updateFactory) {
            super(updateFactory);
        }

        protected Connection getConnection() throws SQLException {
            return AbstractCrudTemplate.this.getConnection();
        }
    }

    protected class InsertTemplateImpl
    extends AbstractInsertTemplate {
        public InsertTemplateImpl(QueryFactory insertFactory) {
            super(insertFactory);
        }

        protected Connection getConnection() throws SQLException {
            return AbstractCrudTemplate.this.getConnection();
        }
    }
}

