/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.sxdbutils.rstable.BasicResultColumnMetaData;
import jp.sourceforge.sxdbutils.rstable.BasicResultColumnRepository;
import jp.sourceforge.sxdbutils.rstable.BasicResultRow;
import jp.sourceforge.sxdbutils.rstable.BasicResultTable;
import jp.sourceforge.sxdbutils.rstable.BinaryColumn;
import jp.sourceforge.sxdbutils.rstable.BooleanColumn;
import jp.sourceforge.sxdbutils.rstable.ClobToStringColumn;
import jp.sourceforge.sxdbutils.rstable.NumericColumn;
import jp.sourceforge.sxdbutils.rstable.ObjectColumn;
import jp.sourceforge.sxdbutils.rstable.ResultColumn;
import jp.sourceforge.sxdbutils.rstable.ResultColumnRepository;
import jp.sourceforge.sxdbutils.rstable.ResultRow;
import jp.sourceforge.sxdbutils.rstable.SqlDateColumn;
import jp.sourceforge.sxdbutils.rstable.StringColumn;
import jp.sourceforge.sxdbutils.rstable.TimeColumn;
import jp.sourceforge.sxdbutils.rstable.TimestampColumn;
import org.apache.commons.dbutils.ResultSetHandler;

public class ResultTableHandler
implements ResultSetHandler {
    public Object handle(ResultSet rs) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        ResultColumn[] resultColumns = this.createResultColumns(meta);
        BasicResultColumnRepository repo = new BasicResultColumnRepository(resultColumns);
        return new BasicResultTable(repo, this.createResultRows(rs, repo));
    }

    protected List createResultRows(ResultSet rs, ResultColumnRepository repo) throws SQLException {
        ArrayList<ResultRow> result = new ArrayList<ResultRow>();
        while (rs.next()) {
            result.add(this.createResultRow(rs, repo));
        }
        return result;
    }

    protected ResultRow createResultRow(ResultSet rs, ResultColumnRepository repo) throws SQLException {
        Object[] rowValues = new Object[repo.size()];
        for (int i = 0; i < repo.size(); ++i) {
            ResultColumn resultColumn = repo.getResultColumn(i);
            rowValues[i] = resultColumn.getValue(rs);
        }
        return new BasicResultRow(repo, rowValues);
    }

    protected ResultColumn[] createResultColumns(ResultSetMetaData meta) throws SQLException {
        ResultColumn[] result = new ResultColumn[meta.getColumnCount()];
        for (int i = 0; i < meta.getColumnCount(); ++i) {
            result[i] = this.createResultColumn(meta, i);
        }
        return result;
    }

    protected ResultColumn createResultColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
        switch (meta.getColumnType(columnIndex + 1)) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.createStringTypeColumn(meta, columnIndex);
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.createNumericTypeColumn(meta, columnIndex);
            }
            case 91: {
                return this.createDateTypeColumn(meta, columnIndex);
            }
            case 93: {
                return this.createTimestampTypeColumn(meta, columnIndex);
            }
            case 92: {
                return this.createTimeTypeColumn(meta, columnIndex);
            }
            case 2005: {
                return this.createClobTypeColumn(meta, columnIndex);
            }
            case -3: 
            case -2: 
            case 2004: {
                return this.createBinaryTypeColumn(meta, columnIndex);
            }
            case 16: {
                return this.createBooleanTypeColumn(meta, columnIndex);
            }
        }
        return this.createOthersTypeColumn(meta, columnIndex);
    }

    protected ResultColumn createStringTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
        return new StringColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
    }

    protected ResultColumn createClobTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
        return new ClobToStringColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
    }

    protected ResultColumn createNumericTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
        return new NumericColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
    }

    protected ResultColumn createDateTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
        return new SqlDateColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
    }

    protected ResultColumn createTimestampTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
        return new TimestampColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
    }

    protected ResultColumn createTimeTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
        return new TimeColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
    }

    protected ResultColumn createBinaryTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
        return new BinaryColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
    }

    protected ResultColumn createBooleanTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
        return new BooleanColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
    }

    protected ResultColumn createOthersTypeColumn(ResultSetMetaData meta, int columnIndex) throws SQLException {
        return new ObjectColumn(columnIndex, new BasicResultColumnMetaData(meta, columnIndex + 1));
    }
}

