package jp.sourceforge.sxdbutils.rstable;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

import jp.sourceforge.sxdbutils.util.SqlDateUtils;

public class NumericColumn extends AbstractColumn/*<BigDecimal>*/{

	static final BigDecimal ONE = new BigDecimal("1");

	public NumericColumn(int columnIndex, ResultColumnMetaData columnMeta) {
		super(columnIndex, columnMeta);
	}

	public Object valueOf(ResultSet rset) throws SQLException {
		return rset.getBigDecimal(columnIndex + 1);
	}

	public BigDecimal getBigDecimal(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		return ((BigDecimal) value);
	}

	public boolean getBoolean(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return false;
		return ONE.compareTo(((BigDecimal) value)) == 0;
	}

	public Boolean getBooleanObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return Boolean.valueOf(ONE.compareTo(((BigDecimal) value)) == 0);
	}

	public byte getByte(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return (byte) 0;
		return ((BigDecimal) value).byteValue();
	}

	public Byte getByteObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Byte(((BigDecimal) value).byteValue());
	}

	public byte[] getBytes(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new byte[0];

	}

	public char getChar(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return '\u0000';
		int i = ((BigDecimal) value).intValue();
		if (0 <= i && i <= 9)
			return String.valueOf(i).charAt(0);
		return '?';
	}

	public Character getCharacter(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		int i = ((BigDecimal) value).intValue();
		if (0 <= i && i <= 9)
			return new Character(String.valueOf(i).charAt(0));
		return new Character('?');
	}

	public Date getDate(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Date(((BigDecimal) value).longValue());
	}

	public double getDouble(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return 0d;
		return ((BigDecimal) value).doubleValue();
	}

	public Double getDoubleObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Double(((BigDecimal) value).doubleValue());
	}

	public float getFloat(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return 0f;
		return ((BigDecimal) value).floatValue();
	}

	public Float getFloatObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Float(((BigDecimal) value).floatValue());
	}

	public int getInt(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return 0;
		return ((BigDecimal) value).intValue();
	}

	public Integer getInteger(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Integer(((BigDecimal) value).intValue());
	}

	public long getLong(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return 0L;
		return ((BigDecimal) value).longValue();
	}

	public Long getLongObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Long(((BigDecimal) value).longValue());
	}

	public short getShort(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return (short) 0;
		return ((BigDecimal) value).shortValue();
	}

	public Short getShortObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Short(((BigDecimal) value).shortValue());
	}

	public java.sql.Date getSqlDate(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return SqlDateUtils.toSqlDate(((BigDecimal) value).longValue());
	}

	public String getString(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return value.toString();
	}

	public Time getTime(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return SqlDateUtils.toSqlTime(((BigDecimal) value).longValue());
	}

	public Timestamp getTimestamp(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;

		return new Timestamp(((BigDecimal) value).longValue());
	}

}
