package jp.sourceforge.sxdbutils.mapping;

import java.util.Map;

import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.NameConvertUtils;
import jp.sourceforge.sxdbutils.util.OthersUtils;


/**
 * 中間マッピング名に、アンダースコアを除いたカラム名が使用される、 {@link NameMapping}の実装です。
 * 大文字、小文字は区別しません。
 * 
 * @author chinpei
 * 
 */
public class RemoveUnderScoreNameMapping implements NameMapping {

	public String toIntermediateNameFromAttrName(String bindObjectName) {
		return bindObjectName;
	}

	public Map createIntermediateMap() {
		return new CaseInsensitiveHashMap();
	}

	public String toIntermediateNameFromColumnName(String columnName) {
		return OthersUtils.remove(columnName, '_');
	}
	
	public String toColumnNameFromAttrName(String bindObjectName) {
		return NameConvertUtils.camelToColumnName(bindObjectName);
	}

}
