package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

import jp.sourceforge.sxdbutils.SxRowProcessor;

import org.apache.commons.dbutils.ResultSetHandler;

/**
 * 複数行を処理するハンドラです。
 * 
 * @author chinpei
 * 
 */
public class SetHandler implements ResultSetHandler {

	protected final SxRowProcessor processor;

	public SetHandler(SxRowProcessor processor) {
		this.processor = processor;
	}

	public SetHandler() {
		this.processor = null;
	}

	protected SxRowProcessor getProcessor() {
		if (processor == null) {
			throw new IllegalStateException("SxRowProcessorが指定されていません。"
					+ "引数なしのコンストラクタを使用する場合、"
					+ "必ずgetProcessorメソッドをオーバーライドしてください。");
		}
		return this.processor;
	}

	public Object handle(ResultSet rs) throws SQLException {
		Set rows = createSet();
		if (rs.next()) {
			SxRowProcessor proc = getProcessor();
			proc.init(rs.getMetaData());
			do {
				rows.add(proc.process(rs));
			} while (rs.next());
		}
		return rows;
	}

	private Set createSet() {
		return new HashSet();
	}

}
