/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.tiger.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;
import jp.sourceforge.sxdbutils.tiger.template.AbstractDeleteTemplate;
import jp.sourceforge.sxdbutils.tiger.template.AbstractInsertTemplate;
import jp.sourceforge.sxdbutils.tiger.template.AbstractSelectTemplate;
import jp.sourceforge.sxdbutils.tiger.template.AbstractUpdateTemplate;
import jp.sourceforge.sxdbutils.tiger.template.CrudTemplate;
import jp.sourceforge.sxdbutils.tiger.template.DeleteTemplate;
import jp.sourceforge.sxdbutils.tiger.template.InsertTemplate;
import jp.sourceforge.sxdbutils.tiger.template.SelectTemplate;
import jp.sourceforge.sxdbutils.tiger.template.UpdateTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCrudTemplate<E>
implements CrudTemplate<E> {
    protected final SelectTemplate<E> selectTemplate = new SelectTemplateImpl();
    protected final InsertTemplate<E> insertTemplate;
    protected final UpdateTemplate<E> updateTemplate;
    protected final DeleteTemplate<E> deleteTemplate;

    protected abstract Connection getConnection() throws SQLException;

    protected abstract Class<E> getEntityClass();

    protected abstract <X extends E> SxRowProcessor<X> createRowProcessor(Class<X> var1);

    public AbstractCrudTemplate(QueryFactory insertFactory, QueryFactory updateFactory, QueryFactory deleteFactory) {
        this.insertTemplate = new InsertTemplateImpl(insertFactory);
        this.updateTemplate = new UpdateTemplateImpl(updateFactory);
        this.deleteTemplate = new DeleteTemplateImpl(deleteFactory);
    }

    @Override
    public int[] delete(Collection<E> entities) throws SQLException {
        return this.deleteTemplate.delete(entities);
    }

    @Override
    public int delete(E entity) throws SQLException {
        return this.deleteTemplate.delete(entity);
    }

    @Override
    public int[] deleteBatch(Collection<E> entities) throws SQLException {
        return this.deleteTemplate.deleteBatch(entities);
    }

    @Override
    public int insert(E entity) throws SQLException {
        return this.insertTemplate.insert(entity);
    }

    @Override
    public int[] insert(Collection<E> entities) throws SQLException {
        return this.insertTemplate.insert(entities);
    }

    @Override
    public int[] insertBatch(Collection<E> entities) throws SQLException {
        return this.insertTemplate.insertBatch(entities);
    }

    @Override
    public <X extends E> X executeQueryToEntity(Query query, Class<X> entityClass) throws SQLException {
        return this.selectTemplate.executeQueryToEntity(query, entityClass);
    }

    @Override
    public E executeQueryToBean(Query query) throws SQLException {
        return this.selectTemplate.executeQueryToBean(query);
    }

    @Override
    public <X extends E> List<X> executeQueryToEntityList(Query query, Class<X> entityClass) throws SQLException {
        return this.selectTemplate.executeQueryToEntityList(query, entityClass);
    }

    @Override
    public List<E> executeQueryToEntityList(Query query) throws SQLException {
        return this.selectTemplate.executeQueryToEntityList(query);
    }

    @Override
    public int[] update(Collection<E> entities) throws SQLException {
        return this.updateTemplate.update(entities);
    }

    @Override
    public int update(E entity) throws SQLException {
        return this.updateTemplate.update(entity);
    }

    @Override
    public int[] updateBatch(Collection<E> entities) throws SQLException {
        return this.updateTemplate.updateBatch(entities);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SelectTemplateImpl
    extends AbstractSelectTemplate<E> {
        protected SelectTemplateImpl() {
        }

        @Override
        protected <X extends E> SxRowProcessor<X> createRowProcessor(Class<X> targetClass) {
            return AbstractCrudTemplate.this.createRowProcessor(targetClass);
        }

        @Override
        protected Class<E> getEntityClass() {
            return AbstractCrudTemplate.this.getEntityClass();
        }

        @Override
        protected Connection getConnection() throws SQLException {
            return AbstractCrudTemplate.this.getConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DeleteTemplateImpl
    extends AbstractDeleteTemplate<E> {
        public DeleteTemplateImpl(QueryFactory deleteFactory) {
            super(deleteFactory);
        }

        @Override
        protected Connection getConnection() throws SQLException {
            return AbstractCrudTemplate.this.getConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UpdateTemplateImpl
    extends AbstractUpdateTemplate<E> {
        public UpdateTemplateImpl(QueryFactory updateFactory) {
            super(updateFactory);
        }

        @Override
        protected Connection getConnection() throws SQLException {
            return AbstractCrudTemplate.this.getConnection();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class InsertTemplateImpl
    extends AbstractInsertTemplate<E> {
        public InsertTemplateImpl(QueryFactory insertFactory) {
            super(insertFactory);
        }

        @Override
        protected Connection getConnection() throws SQLException {
            return AbstractCrudTemplate.this.getConnection();
        }
    }
}

