package jp.sourceforge.sxdbutils.tiger.template.bean;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.tiger.bean.BeanPersistenceHelper;

public abstract class AbstractUpdateTemplate<E> implements UpdateTemplate<E> {

	protected abstract Connection getConnection() throws SQLException;

	protected final QueryFactory updateFactory;
	protected BeanPersistenceHelper<E> persistenceHelper = new BeanPersistenceHelper<E>();

	public AbstractUpdateTemplate(QueryFactory updateFactory) {
		this.updateFactory = updateFactory;
	}

	public int[] update(Collection<E> beans) throws SQLException {
		return persistenceHelper.execute(getConnection(), updateFactory, beans);
	}

	public int update(E bean) throws SQLException {
		return persistenceHelper.execute(getConnection(), updateFactory, bean);
	}

	public int[] updateBatch(Collection<E> beans) throws SQLException {
		return persistenceHelper.executeBatch(getConnection(), updateFactory,
				beans);
	}
}
