/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.tiger.template;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.tiger.SxQueryRunner;
import jp.sourceforge.sxdbutils.tiger.template.AbstractBeanQueryTemplate;
import jp.sourceforge.sxdbutils.tiger.template.BeanUpdateTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBeanUpdateTemplate<E>
extends AbstractBeanQueryTemplate<E>
implements BeanUpdateTemplate<E> {
    protected int[] executeBatch(String sql, Object[][] params) throws SQLException {
        SxQueryRunner runner = new SxQueryRunner();
        return runner.batch(this.getConnection(), sql, params);
    }

    protected int executeUpdate(Query query) throws SQLException {
        SxQueryRunner runner = new SxQueryRunner();
        return runner.update(this.getConnection(), query);
    }

    protected int[] executeUpdates(List<Query> queries) throws SQLException {
        int[] result = new int[queries.size()];
        SxQueryRunner runner = new SxQueryRunner();
        for (int i = 0; i < queries.size(); ++i) {
            result[i] = runner.update(this.getConnection(), queries.get(i));
        }
        return result;
    }

    protected abstract QueryFactory getInsertFactory();

    protected abstract QueryFactory getUpdateFactory();

    @Override
    public int insert(E bean) throws SQLException {
        Query q = this.getInsertFactory().toQuery(bean);
        return this.executeUpdate(q);
    }

    @Override
    public int[] insert(Collection<E> beans) throws SQLException {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (E bean : beans) {
            Query q = this.getInsertFactory().toQuery(bean);
            queries.add(q);
        }
        return this.executeUpdates(queries);
    }

    @Override
    public int update(E bean) throws SQLException {
        Query q = this.getUpdateFactory().toQuery(bean);
        return this.executeUpdate(q);
    }

    @Override
    public int[] update(Collection<E> beans) throws SQLException {
        ArrayList<Query> queries = new ArrayList<Query>();
        for (E bean : beans) {
            Query q = this.getUpdateFactory().toQuery(bean);
            queries.add(q);
        }
        return this.executeUpdates(queries);
    }

    @Override
    public int[] insertBatch(Collection<E> beans) throws SQLException {
        QueryFactory insertFactory = this.getInsertFactory();
        Object[][] batchParams = new Object[beans.size()][];
        int i = 0;
        for (E bean : beans) {
            batchParams[i++] = insertFactory.toBindParameters(bean);
        }
        return this.executeBatch(insertFactory.getSql(), batchParams);
    }

    @Override
    public int[] updateBatch(Collection<E> beans) throws SQLException {
        QueryFactory updateFactory = this.getUpdateFactory();
        Object[][] batchParams = new Object[beans.size()][];
        int i = 0;
        for (E bean : beans) {
            batchParams[i++] = updateFactory.toBindParameters(bean);
        }
        return this.executeBatch(updateFactory.getSql(), batchParams);
    }
}

