package jp.sourceforge.sxdbutils.query;

import jp.sourceforge.sxdbutils.bean.BeanColumn;

public class BeanQueryFactory implements QueryFactory {
	private final String sql;
	private final BeanColumn[] beanColumns;

	BeanQueryFactory(String sql, BeanColumn[] beanColumns) {
		this.sql = sql;
		this.beanColumns = beanColumns;
	}

	public Query toQuery(Object object) {
		SimpleQueryBuilder builder = new SimpleQueryBuilder(this.sql);
		for (int i = 0; i < beanColumns.length; i++) {
			builder.bind(beanColumns[i].read(object));
		}
		return builder.toQuery();
	}

	public String getSql() {
		return this.sql;
	}

	public Object[] toBindParameters(Object object) {
		Object[] params = new Object[beanColumns.length];
		for (int i = 0; i < beanColumns.length; i++) {
			params[i] = beanColumns[i].read(object);
		}
		return params;
	}

}
