package jp.sourceforge.sxdbutils.types;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IntegerType extends AbstractValueType {
	private static final Integer ZERO = new Integer(0);
	private final boolean primitive;

	public IntegerType(boolean primitive) {
		this.primitive = primitive;
	}

	public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
		BigDecimal bd = rset.getBigDecimal(columnIndex);
		if (bd == null)
			return primitive ? ZERO : null;
		return new Integer(bd.intValue());
	}
	// protected int getSqlType() {
	// return Types.INTEGER;
	// }

}
