/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sourceforge.sxdbutils.tiger;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.sql.DataSource;

import jp.sourceforge.sxdbutils.query.Query;

/**
 * {@link jp.sourceforge.sxdbutils.SxQueryRunner}のジェネリクス対応版です。
 * 
 * @author chinpei
 * 
 */
public class SxQueryRunner extends jp.sourceforge.sxdbutils.SxQueryRunner {
	public static final Object[] EMPTY_ARRAY = new Object[0];

	public SxQueryRunner() {
		super();
	}

	public SxQueryRunner(boolean pmdKnownBroken) {
		super(pmdKnownBroken);
	}

	public SxQueryRunner(DataSource ds, boolean pmdKnownBroken) {
		super(ds, pmdKnownBroken);
	}

	public SxQueryRunner(DataSource ds) {
		super(ds);
	}

	@Deprecated
	public <S> S query(Connection conn, String sql, Object param,
			SxResultSetHandler<S> rsh) throws SQLException {
		return this.query(conn, sql, rsh, param);
	}

	public <S> S query(Connection conn, String sql, SxResultSetHandler<S> rsh,
			Object param) throws SQLException {
		return this.query(conn, sql, rsh, new Object[] { param });
	}

	@Deprecated
	public <S> S query(Connection conn, String sql, Object[] params,
			SxResultSetHandler<S> rsh) throws SQLException {
		return query(conn, sql, rsh, params);
	}

	public <S> S query(Connection conn, String sql, SxResultSetHandler<S> rsh,
			Object[] params) throws SQLException {

		PreparedStatement stmt = null;
		ResultSet rs = null;
		S result = null;

		try {
			stmt = this.prepareStatement(conn, sql);
			this.fillStatement(stmt, params);
			rs = this.wrap(stmt.executeQuery());
			result = rsh.handle(rs);

		} catch (SQLException e) {
			this.rethrow(e, sql, params);

		} finally {
			try {
				close(rs);
			} finally {
				close(stmt);
			}
		}

		return result;
	}

	@Deprecated
	public <S> S query(Connection conn, String sql, SxResultSetHandler<S> rsh)
			throws SQLException {
		return this.query(conn, sql, rsh, EMPTY_ARRAY);
	}

	public <S> S query(String sql, Object param, SxResultSetHandler<S> rsh)
			throws SQLException {

		return this.query(sql, new Object[] { param }, rsh);
	}

	@Deprecated
	public <S> S query(String sql, Object[] params, SxResultSetHandler<S> rsh)
			throws SQLException {
		return query(sql, rsh, params);

	}

	public <S> S query(String sql, SxResultSetHandler<S> rsh, Object[] params)
			throws SQLException {

		Connection conn = this.prepareConnection();

		try {
			return this.query(conn, sql, rsh, params);
		} finally {
			close(conn);
		}
	}

	/**
	 * Queryを指定できるqueryメソッド。
	 * 
	 * @param <S>
	 * @param conn
	 * @param query
	 * @param rsh
	 * @return
	 * @throws SQLException
	 */
	public <S> S query(Connection conn, Query query, SxResultSetHandler<S> rsh)
			throws SQLException {
		return this.query(conn, query.getSql(), rsh, query.getParameters());
	}

	/**
	 * Query指定できるqueryメソッド。
	 * 
	 * @param <S>
	 * @param query
	 * @param rsh
	 * @return
	 * @throws SQLException
	 */
	public <S> S query(Query query, SxResultSetHandler<S> rsh)
			throws SQLException {
		return this.query(query.getSql(), rsh, query.getParameters());
	}

	public <S> S query(String sql, SxResultSetHandler<S> rsh)
			throws SQLException {
		return this.query(sql, rsh, EMPTY_ARRAY);
	}

}
