package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.processors.ValueRowProcessor;

import org.apache.commons.dbutils.ResultSetHandler;

/**
 * 結果をMapで返すハンドラです。特定の項目がキーになります。
 * 
 * @author chinpei
 * 
 */
public class KeyedHandler implements ResultSetHandler {

	protected final SxRowProcessor keyProcessor;

	protected final SxRowProcessor valueProcessor;

	public KeyedHandler(String keyColumnName, Class type,
			SxRowProcessor processor) {
		this(new ValueRowProcessor(keyColumnName, type), processor);
	}

	public KeyedHandler(String keyColumnName, SxRowProcessor processor) {
		this(new ValueRowProcessor(keyColumnName), processor);
	}

	public KeyedHandler(int keyColumnIndex, Class keyType,
			SxRowProcessor processor) {
		this(new ValueRowProcessor(keyColumnIndex, keyType), processor);
	}

	public KeyedHandler(int columnIndex, SxRowProcessor processor) {
		this(new ValueRowProcessor(columnIndex), processor);
	}

	public KeyedHandler(SxRowProcessor keyProcessor, SxRowProcessor processor) {
		this.keyProcessor = keyProcessor;
		this.valueProcessor = processor;
	}

	public Object handle(ResultSet rs) throws SQLException {
		Map result = createMap();

		if (rs.next()) {
			keyProcessor.init(rs.getMetaData());
			valueProcessor.init(rs.getMetaData());
			do {
				result
						.put(keyProcessor.process(rs), valueProcessor
								.process(rs));
			} while (rs.next());
		}
		return result;
	}

	protected Map createMap() {
		return new LinkedHashMap();
	}

}
