/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.tiger.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.tiger.SxResultSetHandler;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;
import jp.sourceforge.sxdbutils.tiger.processors.ValueRowProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyedHandler<K, V>
implements SxResultSetHandler<Map<K, V>> {
    protected final SxRowProcessor<K> keyProcessor;
    protected final SxRowProcessor<V> valueProcessor;

    public KeyedHandler(String keyColumnName, Class<K> type, SxRowProcessor<V> processor) {
        this(new ValueRowProcessor<K>(keyColumnName, type), processor);
    }

    public KeyedHandler(String keyColumnName, SxRowProcessor<V> processor) {
        this(new ValueRowProcessor(keyColumnName), processor);
    }

    public KeyedHandler(int keyColumnIndex, Class<K> keyType, SxRowProcessor<V> processor) {
        this(new ValueRowProcessor<K>(keyColumnIndex, keyType), processor);
    }

    public KeyedHandler(int columnIndex, SxRowProcessor<V> processor) {
        this(new ValueRowProcessor(columnIndex), processor);
    }

    public KeyedHandler(SxRowProcessor<K> keyProcessor, SxRowProcessor<V> processor) {
        this.keyProcessor = keyProcessor;
        this.valueProcessor = processor;
    }

    @Override
    public Map<K, V> handle(ResultSet rs) throws SQLException {
        Map<K, V> result = this.createMap();
        if (rs.next()) {
            this.keyProcessor.init(rs.getMetaData());
            this.valueProcessor.init(rs.getMetaData());
            do {
                result.put(this.keyProcessor.process(rs), this.valueProcessor.process(rs));
            } while (rs.next());
        }
        return result;
    }

    protected Map<K, V> createMap() {
        return new LinkedHashMap();
    }
}

