/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.query;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.SimpleQueryBuilder;

public class SimpleInsertBuilder {
    private final String tableName;
    private Map entries = new LinkedHashMap();

    public SimpleInsertBuilder(String tableName) {
        this.tableName = tableName;
    }

    public SimpleInsertBuilder add(String columnName, Object value) {
        this.entries.put(columnName, value);
        return this;
    }

    public SimpleInsertBuilder addAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.entries.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public SimpleInsertBuilder add(String columnName, int value) {
        return this.add(columnName, new Integer(value));
    }

    public SimpleInsertBuilder add(String columnName, long value) {
        return this.add(columnName, new Long(value));
    }

    public SimpleInsertBuilder add(String columnName, double value) {
        return this.add(columnName, new Double(value));
    }

    public SimpleInsertBuilder add(String columnName, float value) {
        return this.add(columnName, new Float(value));
    }

    public SimpleInsertBuilder add(String columnName, short value) {
        return this.add(columnName, new Short(value));
    }

    public SimpleInsertBuilder add(String columnName, byte value) {
        return this.add(columnName, new Byte(value));
    }

    public SimpleInsertBuilder add(String columnName, char value) {
        return this.add(columnName, String.valueOf(value));
    }

    public Query toQuery() {
        SimpleQueryBuilder builder = new SimpleQueryBuilder(256);
        builder.append("insert into ").append(this.tableName).append(" (");
        StringBuffer valuesPart = new StringBuffer(" values( ");
        boolean flg = false;
        Iterator iterator = this.entries.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (flg) {
                builder.append(',');
                valuesPart.append(',');
            }
            flg = true;
            builder.append((String)entry.getKey()).bind(entry.getValue());
            valuesPart.append('?');
        }
        builder.append(" ) ").append(valuesPart).append(")");
        return builder.toQuery();
    }
}

