/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.processors.ValueRowProcessor;
import org.apache.commons.dbutils.ResultSetHandler;

public class KeyedHandler
implements ResultSetHandler {
    protected final SxRowProcessor keyProcessor;
    protected final SxRowProcessor valueProcessor;

    public KeyedHandler(String columnName, Class type, SxRowProcessor processor) {
        this.keyProcessor = new ValueRowProcessor(columnName, type);
        this.valueProcessor = processor;
    }

    public KeyedHandler(String columnName, SxRowProcessor processor) {
        this.keyProcessor = new ValueRowProcessor(columnName);
        this.valueProcessor = processor;
    }

    public KeyedHandler(int columnIndex, Class type, SxRowProcessor processor) {
        this.keyProcessor = new ValueRowProcessor(columnIndex, type);
        this.valueProcessor = processor;
    }

    public KeyedHandler(int columnIndex, SxRowProcessor processor) {
        this.keyProcessor = new ValueRowProcessor(columnIndex);
        this.valueProcessor = processor;
    }

    public Object handle(ResultSet rs) throws SQLException {
        Map result = this.createMap();
        if (rs.next()) {
            this.keyProcessor.init(rs.getMetaData());
            this.valueProcessor.init(rs.getMetaData());
            do {
                result.put(this.keyProcessor.process(rs), this.valueProcessor.process(rs));
            } while (rs.next());
        }
        return result;
    }

    protected Map createMap() {
        return new LinkedHashMap();
    }
}

