package jp.sourceforge.sxdbutils.bean;

import java.beans.PropertyDescriptor;
import java.util.Map;

import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.NameConvertUtils;

import org.apache.commons.lang.StringUtils;

/**
 * 中間マッピング名に、アンダースコアを除いたカラム名が使用される、 {@link NameMapping}の実装です。
 * 大文字、小文字は区別しません。
 * 
 * @author chinpei
 * 
 */
public class RemoveUnderScoreNameMapping implements NameMapping {

	public String toIntermediateName(PropertyDescriptor propertyDescriptor) {
		return propertyDescriptor.getName();
	}

	public Map createIntermediateMap() {
		return new CaseInsensitiveHashMap();
	}

	public String toIntermediateName(String columnName) {
		return StringUtils.remove(columnName, '_');
	}
	public String toColumnName(PropertyDescriptor propertyDescriptor) {
		return NameConvertUtils.camelToColumnName(propertyDescriptor.getName());
	}

}
