package jp.sourceforge.sxdbutils.bean;

import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;

/**
 * コンストラクタにkeyにプロパティ名を、valueにカラム名をセットしたMapを渡すことができる
 * {@link NameMapping} です。
 * 
 * @author chinpei
 * 
 */
public class OverwriteNameMapping implements NameMapping {

	private static final NameMapping DEFAULT_COMVERSION = new ColumnNameMapping();

	protected final Map propertyToColumnMap;
	protected final Map columnToPropertyMap = new HashMap();

	protected final NameMapping defaultNameMapping;

	public OverwriteNameMapping(Map propertyToColumnMap) {
		this(propertyToColumnMap, DEFAULT_COMVERSION);
	}

	public OverwriteNameMapping(Map propertyToColumnMap,
			NameMapping defaultNameMapping) {
		this.propertyToColumnMap = new HashMap(propertyToColumnMap);
		for (Iterator iterator = this.propertyToColumnMap.entrySet().iterator(); iterator
				.hasNext();) {
			Map.Entry entry = (Map.Entry) iterator.next();
			columnToPropertyMap.put(entry.getValue(), entry.getKey());
		}
		this.defaultNameMapping = defaultNameMapping;
	}

	public String toIntermediateName(PropertyDescriptor propertyDescriptor) {
		String name = propertyDescriptor.getName();
		return (this.propertyToColumnMap.containsKey(name)) ? name : defaultNameMapping
				.toIntermediateName(propertyDescriptor);
	}
	public String toColumnName(PropertyDescriptor propertyDescriptor) {
		String name = propertyDescriptor.getName();
		return (this.propertyToColumnMap.containsKey(name)) ? name : defaultNameMapping
				.toColumnName(propertyDescriptor);
	}

	public final Map createIntermediateMap() {
		return new CaseInsensitiveHashMap();
	}

	public String toIntermediateName(String columnName) {
		String name = (String) columnToPropertyMap.get(columnName);
		return name == null ? defaultNameMapping.toIntermediateName(columnName) : name;
	}
}
