package jp.ac.do_johodai.j314.sw.lms;

import org.w3c.dom.*;

//imsmanifest.xmlを解析してSCOのメタデータを抽出する処理を
//するためのクラス．
//今のところimsmanifest.xmlの全ての情報を扱っているわけではない．
//<organizations>の中身は全部無視しているし，<resource>はSCOしか
//読まない．しかも，imsmanifest.xmlの形式には条件がある．
//条件とは<resource>の<metadata>は必ず<adlcp:location>を使って
//外部XML(LOM)ファイルで記述するようにしなければならない．
class ProcessManifest {
    //imsmanifest.xmlを処理するxpath
    //scormType=scoのresourceを取り出すxpath
    static String xpath0 = "/manifest/resources/resource[@scormType='sco']";
    //scormType=scoのresource数を数えるxpath
    static String xpath1 = "count("+xpath0+")";
    //scormType=scoのresourceに設定されている教材のhrefの数を数えるxpath
    static String xpath2 = "count("+xpath0+"/@href)";
    //scormType=scoのresourceに設定されている外部メタデータの数を数えるxpath
    static String xpath3 = "count("+xpath0+"/metadata/location/text())";
    //%d番目の外部メタデータを取り出すためのxpath
    static String xpath4 = xpath0+"[%d]/metadata/location/text()";
    //%d番目の教材のhrefを取り出すためのxpath
    static String xpath5 = xpath0+"[%d]/@href";

    static MetaData[] process(String manifest_url) {
        try {
            Document d1 = Util.loadXML(manifest_url);

            int num1 = (int)Util.xpath_num(xpath1,d1);
            int num2 = (int)Util.xpath_num(xpath2,d1);
            int num3 = (int)Util.xpath_num(xpath3,d1);

            if ((num1!=num2)||(num2!=num3)&&(num3!=num1)) {
                System.out.println("ProcessManifest.process(). unsupported imsmanifest?!");
                return null;
            }

            String base = manifest_url.substring(0,manifest_url.lastIndexOf('/'));
            MetaData md[] = new MetaData[num1];
            for (int i=0;i<md.length;i++) {
                String sTmp = Util.xpath_str2(String.format(xpath4,(i+1)),d1);
                Document d2 = Util.loadXML(base+"/"+sTmp.trim());

                md[i] = new MetaData();
                //url
                sTmp = Util.xpath_str2(String.format(xpath5,(i+1)),d1);
                md[i].url = base + "/" + sTmp.trim();

                //type
                //...
                md[i].type = "edu_material";
                //title 1.2
                md[i].title = Util.xpath_str2("/lom/general/title",d2).trim();
                //description 1.5
                md[i].description = Util.xpath_str2("/lom/general/description",d2).trim();
                //creator 2.3
                md[i].creator = Util.xpath_str2("/lom/lifecycle/contribute/value/langstring",d2).trim();
                //created 2.3.3微妙
                md[i].created = Util.xpath_str2("/lom/lifecycle/contribute/date/datetime",d2).trim();
                //modified ?.?.?
                md[i].modified = null;
                //requires 7
                num1 = (int)Util.xpath_num("count(/lom/relation/resource/catalogentry)",d2);
                String ssTmp[] = new String[num1];
                for (int j=0;j<num1;j++) {
                    ssTmp[j] = Util.xpath_str2("/lom/relation/resource/catalogentry["+(j+1)+"]/entry/langstring",d2).trim();
                }
                md[i].requires = ssTmp;
                //hasPart 1.6
                num1 = (int)Util.xpath_num("count(/lom/general/keyword)",d2);
                ssTmp = new String[num1];
                for (int j=0;j<num1;j++) {
                    ssTmp[j] = Util.xpath_str2("/lom/general/keyword["+(j+1)+"]/langstring",d2).trim();
                }
                md[i].hasPart = ssTmp;
                //difficulty 5.8
                md[i].difficulty = Util.xpath_str2("/lom/educational/difficulty/Vocabulary/value/langstring",d2).trim();
                //learningtime 5.9
                md[i].learningtime = Util.xpath_str2("/lom/educational/typicalLearningTime/Duration/value",d2).trim();
                md[i].learningtime = md[i].learningtime.replaceAll("PT", "0");
                md[i].learningtime = md[i].learningtime.replaceAll("H", ":");
                md[i].learningtime = md[i].learningtime.replaceAll("M", ":");
                md[i].learningtime = md[i].learningtime.replaceAll("S", "");
            }

            return md;
        } catch(Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
